/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;

public interface WebSocket {
    public void onOpen(Connection var1);

    public void onClose(int var1, String var2);

    public static interface Connection {
        public String getProtocol();

        public void sendMessage(String var1) throws IOException;

        public void sendMessage(byte[] var1, int var2, int var3) throws IOException;

        public void disconnect();

        public boolean isOpen();

        public void setMaxIdleTime(int var1);

        public void setMaxTextMessageSize(int var1);

        public void setMaxBinaryMessageSize(int var1);

        public int getMaxIdleTime();

        public int getMaxTextMessageSize();

        public int getMaxBinaryMessageSize();
    }

    public static interface FrameConnection
    extends Connection {
        public void close(int var1, String var2);

        public byte binaryOpcode();

        public byte textOpcode();

        public byte continuationOpcode();

        public byte finMask();

        public void setAllowFrameFragmentation(boolean var1);

        public boolean isMessageComplete(byte var1);

        public boolean isControl(byte var1);

        public boolean isText(byte var1);

        public boolean isBinary(byte var1);

        public boolean isContinuation(byte var1);

        public boolean isClose(byte var1);

        public boolean isPing(byte var1);

        public boolean isPong(byte var1);

        public boolean isAllowFrameFragmentation();

        public void sendControl(byte var1, byte[] var2, int var3, int var4) throws IOException;

        public void sendFrame(byte var1, byte var2, byte[] var3, int var4, int var5) throws IOException;
    }

    public static interface OnBinaryMessage
    extends WebSocket {
        public void onMessage(byte[] var1, int var2, int var3);
    }

    public static interface OnControl
    extends WebSocket {
        public boolean onControl(byte var1, byte[] var2, int var3, int var4);
    }

    public static interface OnFrame
    extends WebSocket {
        public boolean onFrame(byte var1, byte var2, byte[] var3, int var4, int var5);

        public void onHandshake(FrameConnection var1);
    }

    public static interface OnTextMessage
    extends WebSocket {
        public void onMessage(String var1);
    }
}

