/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;

public class RedirectListener
extends HttpEventListenerWrapper {
    private final HttpExchange _exchange;
    private HttpDestination _destination;
    private String _location;
    private int _attempts;
    private boolean _requestComplete;
    private boolean _responseComplete;
    private boolean _redirected;

    public RedirectListener(HttpDestination destination, HttpExchange ex) {
        super(ex.getEventListener(), true);
        this._destination = destination;
        this._exchange = ex;
    }

    public void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
        boolean bl = this._redirected = (status == 301 || status == 302) && this._attempts < this._destination.getHttpClient().maxRedirects();
        if (this._redirected) {
            this.setDelegatingRequests(false);
            this.setDelegatingResponses(false);
        }
        super.onResponseStatus(version, status, reason);
    }

    public void onResponseHeader(Buffer name, Buffer value) throws IOException {
        if (this._redirected) {
            int header = HttpHeaders.CACHE.getOrdinal(name);
            switch (header) {
                case 45: {
                    this._location = value.toString();
                }
            }
        }
        super.onResponseHeader(name, value);
    }

    public void onRequestComplete() throws IOException {
        this._requestComplete = true;
        if (this.checkExchangeComplete()) {
            super.onRequestComplete();
        }
    }

    public void onResponseComplete() throws IOException {
        this._responseComplete = true;
        if (this.checkExchangeComplete()) {
            super.onResponseComplete();
        }
    }

    public boolean checkExchangeComplete() throws IOException {
        if (this._redirected && this._requestComplete && this._responseComplete) {
            if (this._location != null) {
                if (this._location.indexOf("://") > 0) {
                    this._exchange.setURL(this._location);
                } else {
                    this._exchange.setRequestURI(this._location);
                }
                HttpDestination destination = this._destination.getHttpClient().getDestination(this._exchange.getAddress(), "https".equals(String.valueOf(this._exchange.getScheme())));
                if (this._destination == destination) {
                    this._destination.resend(this._exchange);
                } else {
                    HttpEventListener listener = this;
                    while (listener instanceof HttpEventListenerWrapper) {
                        listener = ((HttpEventListenerWrapper)listener).getEventListener();
                    }
                    this._exchange.getEventListener().onRetry();
                    this._exchange.reset();
                    this._exchange.setEventListener(listener);
                    destination.send(this._exchange);
                }
                return false;
            }
            this.setDelegationResult(false);
        }
        return true;
    }

    public void onRetry() {
        this._redirected = false;
        ++this._attempts;
        this.setDelegatingRequests(true);
        this.setDelegatingResponses(true);
        this._requestComplete = false;
        this._responseComplete = false;
        super.onRetry();
    }
}

