/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.jmx;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.monitor.jmx.EventTrigger;
import org.eclipse.jetty.monitor.jmx.MonitorAction;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class MonitorTask
extends TimerTask {
    private static final Logger LOG = Log.getLogger(MonitorTask.class);
    private static Timer __timer = new Timer(true);
    private static ThreadPool _callback = new ExecutorThreadPool(4, 64, 60L, TimeUnit.SECONDS);
    private static Map<String, TimerTask> __tasks = new HashMap<String, TimerTask>();
    private final MonitorAction _action;

    private MonitorTask(MonitorAction action) {
        this._action = action;
    }

    public static void schedule(MonitorAction action) {
        MonitorTask task = new MonitorTask(action);
        __timer.scheduleAtFixedRate((TimerTask)task, action.getPollDelay(), action.getPollInterval());
        __tasks.put(action.getID(), task);
    }

    public static void cancel(MonitorAction action) {
        TimerTask task = __tasks.remove(action.getID());
        if (task != null) {
            task.cancel();
        }
    }

    public final void run() {
        final long timestamp = System.currentTimeMillis();
        final EventTrigger trigger = this._action.getTrigger();
        _callback.dispatch(new Runnable(){

            public void run() {
                try {
                    if (trigger.match(timestamp)) {
                        MonitorTask.this._action.doExecute(timestamp);
                    }
                }
                catch (Exception ex) {
                    LOG.debug((Throwable)ex);
                }
            }
        });
    }
}

