/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.resolver;

import org.osgi.framework.Version;

public class VersionRange
extends org.osgi.framework.VersionRange {
    private static final Version versionMax = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final char INCLUDE_MIN = '[';
    private static final char EXCLUDE_MIN = '(';
    private static final char INCLUDE_MAX = ']';
    private static final char EXCLUDE_MAX = ')';
    public static final VersionRange emptyRange = new VersionRange("0.0.0-");

    public VersionRange(Version minVersion, boolean includeMin, Version maxVersion, boolean includeMax) {
        super(includeMin ? (char)'[' : '(', minVersion == null ? new Version("0.0.0-") : minVersion, versionMax.equals(maxVersion) ? null : maxVersion, includeMax ? (char)']' : ')');
    }

    public VersionRange(String versionRange) {
        super(versionRange == null || versionRange.length() == 0 ? "0.0.0-" : versionRange);
    }

    public Version getMinimum() {
        return this.getLeft();
    }

    public boolean getIncludeMinimum() {
        return this.getLeftType() == '[';
    }

    public Version getMaximum() {
        Version right = this.getRight();
        return right == null ? versionMax : right;
    }

    public boolean getIncludeMaximum() {
        return this.getRightType() == ']';
    }

    public boolean isIncluded(Version version) {
        if (version == null) {
            version = Version.emptyVersion;
        }
        return this.includes(version);
    }
}

