/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private final boolean release;
    private transient String versionString;
    private transient int hash;
    private static final String DOT_SEPARATOR = ".";
    private static final String DASH_SEPARATOR = "-";
    private static final String QUALIFIER_SEPARATORS = ".-";
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null, true);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this(major, minor, micro, qualifier, true);
    }

    public Version(int major, int minor, int micro, String qualifier, boolean release) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.release = release;
        this.validate();
    }

    public Version(String version) {
        this(version, true);
    }

    private Version(String version, boolean rel) {
        int maj = 0;
        int min = 0;
        int mic = 0;
        String qual = "";
        try {
            StringTokenizer st = new StringTokenizer(version, DOT_SEPARATOR, true);
            maj = Version.parseInt(st.nextToken(), version);
            if (st.hasMoreTokens()) {
                st.nextToken();
                min = Version.parseInt(st.nextToken(), version);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    mic = Version.parseInt(st.nextToken(QUALIFIER_SEPARATORS), version);
                    if (st.hasMoreTokens()) {
                        rel = DOT_SEPARATOR.equals(st.nextToken());
                        if (st.hasMoreTokens()) {
                            qual = st.nextToken("");
                            if (st.hasMoreTokens()) {
                                throw new IllegalArgumentException(new StringBuffer("invalid version \"").append(version).append("\": invalid format").toString());
                            }
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            IllegalArgumentException iae = new IllegalArgumentException(new StringBuffer("invalid version \"").append(version).append("\": invalid format").toString());
            iae.initCause(e);
            throw iae;
        }
        this.major = maj;
        this.minor = min;
        this.micro = mic;
        this.qualifier = qual;
        this.release = rel;
        this.validate();
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException iae = new IllegalArgumentException(new StringBuffer("invalid version \"").append(version).append("\": non-numeric \"").append(value).append("\"").toString());
            iae.initCause(e);
            throw iae;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException(new StringBuffer("invalid version \"").append(this.toString0()).append("\": negative number \"").append(this.major).append("\"").toString());
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException(new StringBuffer("invalid version \"").append(this.toString0()).append("\": negative number \"").append(this.minor).append("\"").toString());
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException(new StringBuffer("invalid version \"").append(this.toString0()).append("\": negative number \"").append(this.micro).append("\"").toString());
        }
        char[] cArray = this.qualifier.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '_' || ch == '-')) {
                throw new IllegalArgumentException(new StringBuffer("invalid version \"").append(this.toString0()).append("\": invalid qualifier \"").append(this.qualifier).append("\"").toString());
            }
            ++n2;
        }
    }

    public static Version parseVersion(String version) {
        return Version.parseVersion(version, true);
    }

    static Version parseVersion(String version, boolean rel) {
        if (version == null) {
            return rel ? emptyVersion : new Version(0, 0, 0, null, false);
        }
        if ((version = version.trim()).length() == 0) {
            return rel ? emptyVersion : new Version(0, 0, 0, null, false);
        }
        return new Version(version, rel);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean isReleaseVersion() {
        return this.release;
    }

    public String toString() {
        return this.toString0();
    }

    private String toString0() {
        if (this.versionString != null) {
            return this.versionString;
        }
        int q = this.qualifier.length();
        StringBuffer result = new StringBuffer(20 + q);
        result.append(this.major);
        result.append(DOT_SEPARATOR);
        result.append(this.minor);
        result.append(DOT_SEPARATOR);
        result.append(this.micro);
        if (this.release) {
            if (q > 0) {
                result.append(DOT_SEPARATOR);
                result.append(this.qualifier);
            }
        } else {
            result.append(DASH_SEPARATOR);
            result.append(this.qualifier);
        }
        this.versionString = result.toString();
        return this.versionString;
    }

    void appendTo(StringBuffer buf, boolean emptyQualifier) {
        buf.append(this.toString0());
        if (this.qualifier.length() == 0) {
            if (emptyQualifier) {
                if (this.release) {
                    buf.append(DOT_SEPARATOR);
                }
            } else if (!this.release) {
                buf.setLength(buf.length() - 1);
            }
        }
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = this.release ? 527 : 589;
        h = 31 * h + this.major;
        h = 31 * h + this.minor;
        h = 31 * h + this.micro;
        this.hash = h = 31 * h + this.qualifier.hashCode();
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.release == other.release && this.qualifier.equals(other.qualifier);
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        result = (this.release ? 1 : 0) - (other.release ? 1 : 0);
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }
}

