/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.FileResource;
import org.osgi.framework.Bundle;

public class DefaultFileLocatorHelper
implements BundleFileLocatorHelper {
    private static Field BUNDLE_ENTRY_FIELD = null;
    private static Field FILE_FIELD = null;
    private static Field BUNDLE_FILE_FIELD_FOR_DIR_ZIP_BUNDLE_ENTRY = null;
    private static Field ZIP_FILE_FILED_FOR_ZIP_BUNDLE_FILE = null;
    private static Method BUNDLE_URL_CONNECTION_getLocalURL = null;
    private static Method BUNDLE_URL_CONNECTION_getFileURL = null;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public File getBundleInstallLocation(Bundle bundle) throws Exception {
        URL url = bundle.getEntry("/META-INF/MANIFEST.MF");
        if (url.getProtocol().equals("file")) {
            return new FileResource(url).getFile().getParentFile().getParentFile();
        }
        if (url.getProtocol().equals("bundleentry")) {
            Object bundleEntry;
            URLConnection con = url.openConnection();
            if (BUNDLE_ENTRY_FIELD == null) {
                BUNDLE_ENTRY_FIELD = con.getClass().getDeclaredField("bundleEntry");
                BUNDLE_ENTRY_FIELD.setAccessible(true);
            }
            if ((bundleEntry = BUNDLE_ENTRY_FIELD.get(con)).getClass().getName().equals("org.eclipse.osgi.baseadaptor.bundlefile.FileBundleEntry")) {
                if (FILE_FIELD == null) {
                    FILE_FIELD = bundleEntry.getClass().getDeclaredField("file");
                    FILE_FIELD.setAccessible(true);
                }
                File f = (File)FILE_FIELD.get(bundleEntry);
                return f.getParentFile().getParentFile();
            }
            if (!bundleEntry.getClass().getName().equals("org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleEntry")) {
                if (!bundleEntry.getClass().getName().equals("org.eclipse.osgi.baseadaptor.bundlefile.DirZipBundleEntry")) return null;
                return null;
            }
            url = bundle.getEntry("/");
            con = url.openConnection();
            if (BUNDLE_ENTRY_FIELD == null) {
                BUNDLE_ENTRY_FIELD = con.getClass().getDeclaredField("bundleEntry");
                BUNDLE_ENTRY_FIELD.setAccessible(true);
            }
            bundleEntry = BUNDLE_ENTRY_FIELD.get(con);
            if (BUNDLE_FILE_FIELD_FOR_DIR_ZIP_BUNDLE_ENTRY == null) {
                BUNDLE_FILE_FIELD_FOR_DIR_ZIP_BUNDLE_ENTRY = bundleEntry.getClass().getDeclaredField("bundleFile");
                BUNDLE_FILE_FIELD_FOR_DIR_ZIP_BUNDLE_ENTRY.setAccessible(true);
            }
            Object zipBundleFile = BUNDLE_FILE_FIELD_FOR_DIR_ZIP_BUNDLE_ENTRY.get(bundleEntry);
            if (ZIP_FILE_FILED_FOR_ZIP_BUNDLE_FILE == null) {
                ZIP_FILE_FILED_FOR_ZIP_BUNDLE_FILE = zipBundleFile.getClass().getDeclaredField("zipFile");
                ZIP_FILE_FILED_FOR_ZIP_BUNDLE_FILE.setAccessible(true);
            }
            ZipFile zipFile = (ZipFile)ZIP_FILE_FILED_FOR_ZIP_BUNDLE_FILE.get(zipBundleFile);
            return new File(zipFile.getName());
        }
        if (!"bundle".equals(url.getProtocol())) return null;
        String location = bundle.getLocation();
        if (location.startsWith("file:/")) {
            URI uri = new URI(URIUtil.encodePath((String)location));
            return new File(uri);
        }
        if (location.startsWith("file:")) {
            File res = new File(location.substring("file:".length()));
            if (res.exists()) return res;
            return null;
        }
        if (!location.startsWith("reference:file:")) return null;
        location = URLDecoder.decode(location.substring("reference:".length()), "UTF-8");
        return new File(location.substring("file:".length()));
    }

    @Override
    public File getFileInBundle(Bundle bundle, String path) throws Exception {
        File webapp;
        if (path != null && path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        File bundleInstall = this.getBundleInstallLocation(bundle);
        File file = webapp = path != null && path.length() != 0 ? new File(bundleInstall, path) : bundleInstall;
        if (!webapp.exists()) {
            throw new IllegalArgumentException("Unable to locate " + path + " inside " + bundle.getSymbolicName() + " (" + (bundleInstall != null ? bundleInstall.getAbsolutePath() : " no_bundle_location ") + ")");
        }
        return webapp;
    }

    @Override
    public Enumeration<URL> findEntries(Bundle bundle, String entryPath) {
        String path;
        int last = entryPath.lastIndexOf(47);
        String string = path = last != -1 && last < entryPath.length() - 2 ? entryPath.substring(0, last) : "/";
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String pattern = last != -1 && last < entryPath.length() - 2 ? entryPath.substring(last + 1) : entryPath;
        Enumeration enUrls = bundle.findEntries(path, pattern, false);
        return enUrls;
    }

    @Override
    public File[] locateJarsInsideBundle(Bundle bundle) throws Exception {
        File jasperLocation = this.getBundleInstallLocation(bundle);
        if (jasperLocation.isDirectory()) {
            ArrayList<File> urls = new ArrayList<File>();
            for (File f : jasperLocation.listFiles()) {
                if (f.getName().endsWith(".jar") && f.isFile()) {
                    urls.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : jasperLocation.listFiles()) {
                    if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                    urls.add(f2);
                }
            }
            return urls.toArray(new File[urls.size()]);
        }
        return new File[]{jasperLocation};
    }

    public static URL getLocalURL(URL url) {
        if ("bundleresource".equals(url.getProtocol()) || "bundleentry".equals(url.getProtocol())) {
            try {
                URLConnection conn = url.openConnection();
                if (BUNDLE_URL_CONNECTION_getLocalURL == null && conn.getClass().getName().equals("org.eclipse.osgi.framework.internal.core.BundleURLConnection")) {
                    BUNDLE_URL_CONNECTION_getLocalURL = conn.getClass().getMethod("getLocalURL", null);
                    BUNDLE_URL_CONNECTION_getLocalURL.setAccessible(true);
                }
                if (BUNDLE_URL_CONNECTION_getLocalURL != null) {
                    return (URL)BUNDLE_URL_CONNECTION_getLocalURL.invoke((Object)conn, null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return url;
    }

    public static URL getFileURL(URL url) {
        if ("bundleresource".equals(url.getProtocol()) || "bundleentry".equals(url.getProtocol())) {
            try {
                URLConnection conn = url.openConnection();
                if (BUNDLE_URL_CONNECTION_getFileURL == null && conn.getClass().getName().equals("org.eclipse.osgi.framework.internal.core.BundleURLConnection")) {
                    BUNDLE_URL_CONNECTION_getFileURL = conn.getClass().getMethod("getFileURL", null);
                    BUNDLE_URL_CONNECTION_getFileURL.setAccessible(true);
                }
                if (BUNDLE_URL_CONNECTION_getFileURL != null) {
                    return (URL)BUNDLE_URL_CONNECTION_getFileURL.invoke((Object)conn, null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return url;
    }
}

