/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.IPAddressMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class IPAccessHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(IPAccessHandler.class);
    IPAddressMap<PathMap> _white = new IPAddressMap();
    IPAddressMap<PathMap> _black = new IPAddressMap();

    public IPAccessHandler() {
    }

    public IPAccessHandler(String[] white, String[] black) {
        if (white != null && white.length > 0) {
            this.setWhite(white);
        }
        if (black != null && black.length > 0) {
            this.setBlack(black);
        }
    }

    public void addWhite(String entry) {
        this.add(entry, this._white);
    }

    public void addBlack(String entry) {
        this.add(entry, this._black);
    }

    public void setWhite(String[] entries) {
        this.set(entries, this._white);
    }

    public void setBlack(String[] entries) {
        this.set(entries, this._black);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String addr;
        EndPoint endp;
        AbstractHttpConnection connection = baseRequest.getConnection();
        if (connection != null && (endp = connection.getEndPoint()) != null && (addr = endp.getRemoteAddr()) != null && !this.isAddrUriAllowed(addr, baseRequest.getPathInfo())) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request, response);
    }

    protected void add(String entry, IPAddressMap<PathMap> patternMap) {
        if (entry != null && entry.length() > 0) {
            PathMap pathMap;
            String path;
            int idx;
            boolean deprecated = false;
            if (entry.indexOf(124) > 0) {
                idx = entry.indexOf(124);
            } else {
                idx = entry.indexOf(47);
                deprecated = idx >= 0;
            }
            String addr = idx > 0 ? entry.substring(0, idx) : entry;
            String string = path = idx > 0 ? entry.substring(idx) : "/*";
            if (addr.endsWith(".")) {
                deprecated = true;
            }
            if (path != null && (path.startsWith("|") || path.startsWith("/*."))) {
                path = path.substring(1);
            }
            if ((pathMap = (PathMap)patternMap.get((Object)addr)) == null) {
                pathMap = new PathMap(true);
                patternMap.put(addr, (Object)pathMap);
            }
            if (path != null) {
                pathMap.put((Object)path, (Object)path);
            }
            if (deprecated) {
                LOG.debug(this.toString() + " - deprecated specification syntax: " + entry, new Object[0]);
            }
        }
    }

    protected void set(String[] entries, IPAddressMap<PathMap> patternMap) {
        patternMap.clear();
        if (entries != null && entries.length > 0) {
            for (String addrPath : entries) {
                this.add(addrPath, patternMap);
            }
        }
    }

    protected boolean isAddrUriAllowed(String addr, String path) {
        Object blackObj;
        if (this._white.size() > 0) {
            boolean match = false;
            Object whiteObj = this._white.getLazyMatches(addr);
            if (whiteObj != null) {
                Object entry;
                PathMap pathMap;
                List<Object> whiteList = whiteObj instanceof List ? (List<Object>)whiteObj : Collections.singletonList(whiteObj);
                Iterator<Object> i$ = whiteList.iterator();
                while (i$.hasNext() && !(match = (pathMap = (PathMap)((Map.Entry)(entry = i$.next())).getValue()) != null && (pathMap.size() == 0 || pathMap.match(path) != null))) {
                }
            }
            if (!match) {
                return false;
            }
        }
        if (this._black.size() > 0 && (blackObj = this._black.getLazyMatches(addr)) != null) {
            List<Object> blackList = blackObj instanceof List ? (List<Object>)blackObj : Collections.singletonList(blackObj);
            for (Object entry : blackList) {
                PathMap pathMap = (PathMap)((Map.Entry)entry).getValue();
                if (pathMap == null || pathMap.size() != 0 && pathMap.match(path) == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (LOG.isDebugEnabled()) {
            System.err.println(this.dump());
        }
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.toString());
        buf.append(" WHITELIST:\n");
        this.dump(buf, this._white);
        buf.append(this.toString());
        buf.append(" BLACKLIST:\n");
        this.dump(buf, this._black);
        return buf.toString();
    }

    protected void dump(StringBuilder buf, IPAddressMap<PathMap> patternMap) {
        for (String addr : patternMap.keySet()) {
            for (Object path : ((PathMap)patternMap.get((Object)addr)).values()) {
                buf.append("# ");
                buf.append(addr);
                buf.append("|");
                buf.append(path);
                buf.append("\n");
            }
        }
    }
}

