/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class TagLibConfiguration
extends AbstractConfiguration {
    public static final String TLD_RESOURCES = "org.eclipse.jetty.tlds";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, (String)"javax.servlet.jsp.JspPage");
        }
        catch (Exception e) {
            return;
        }
        TagLibListener tagLibListener = new TagLibListener(context);
        context.addEventListener((EventListener)((Object)tagLibListener));
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    public class TagLibListener
    implements ServletContextListener {
        private List<EventListener> _tldListeners;
        private WebAppContext _context;

        public TagLibListener(WebAppContext context) {
            this._context = context;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            if (this._tldListeners == null) {
                return;
            }
            for (int i = this._tldListeners.size() - 1; i >= 0; --i) {
                EventListener l = this._tldListeners.get(i);
                if (!(l instanceof ServletContextListener)) continue;
                ((ServletContextListener)l).contextDestroyed(sce);
            }
        }

        public void contextInitialized(ServletContextEvent sce) {
            try {
                Set<Resource> tlds = this.findTldResources();
                List<TldDescriptor> descriptors = this.parseTlds(tlds);
                this.processTlds(descriptors);
                if (this._tldListeners == null) {
                    return;
                }
                for (EventListener l : this._tldListeners) {
                    if (l instanceof ServletContextListener) {
                        ((ServletContextListener)l).contextInitialized(sce);
                        continue;
                    }
                    this._context.addEventListener(l);
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }

        private Set<Resource> findTldResources() throws IOException {
            Collection tld_resources;
            Resource web_inf_tlds;
            Resource web_inf;
            HashSet<Resource> tlds = new HashSet<Resource>();
            if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
                for (String location : this._context.getResourceAliases().values()) {
                    if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    Resource l = this._context.getBaseResource().addPath(location);
                    tlds.add(l);
                }
            }
            if ((web_inf = this._context.getWebInf()) != null) {
                String[] contents = web_inf.list();
                for (int i = 0; contents != null && i < contents.length; ++i) {
                    if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                    Resource l = web_inf.addPath(contents[i]);
                    tlds.add(l);
                }
            }
            if (web_inf != null && (web_inf_tlds = this._context.getWebInf().addPath("/tlds/")).exists() && web_inf_tlds.isDirectory()) {
                String[] contents = web_inf_tlds.list();
                for (int i = 0; contents != null && i < contents.length; ++i) {
                    if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                    Resource l = web_inf_tlds.addPath(contents[i]);
                    tlds.add(l);
                }
            }
            if ((tld_resources = (Collection)this._context.getAttribute(TagLibConfiguration.TLD_RESOURCES)) != null) {
                tlds.addAll(tld_resources);
            }
            return tlds;
        }

        private List<TldDescriptor> parseTlds(Set<Resource> tlds) {
            ArrayList<TldDescriptor> descriptors = new ArrayList<TldDescriptor>();
            Resource tld = null;
            Iterator<Resource> iter = tlds.iterator();
            while (iter.hasNext()) {
                try {
                    tld = iter.next();
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("TLD=" + tld));
                    }
                    TldDescriptor d = new TldDescriptor(tld);
                    d.parse();
                    descriptors.add(d);
                }
                catch (Exception e) {
                    Log.warn((String)("Unable to parse TLD: " + tld), (Throwable)e);
                }
            }
            return descriptors;
        }

        private void processTlds(List<TldDescriptor> descriptors) throws Exception {
            TldProcessor processor = new TldProcessor();
            for (TldDescriptor d : descriptors) {
                processor.process(this._context, d);
            }
            this._tldListeners = new ArrayList<EventListener>(processor.getListeners());
        }
    }

    public static class TldDescriptor
    extends Descriptor {
        protected static XmlParser __parserSingleton;

        public TldDescriptor(Resource xml) {
            super(xml);
        }

        @Override
        public void ensureParser() throws ClassNotFoundException {
            if (__parserSingleton == null) {
                __parserSingleton = this.newParser();
            }
            this._parser = __parserSingleton;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XmlParser newParser() throws ClassNotFoundException {
            XmlParser parser = new XmlParser(false);
            URL taglib11 = null;
            URL taglib12 = null;
            URL taglib20 = null;
            URL taglib21 = null;
            try {
                Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, (String)"javax.servlet.jsp.JspPage");
                taglib11 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
                taglib12 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
                taglib20 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd");
                taglib21 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd");
            }
            catch (Exception e) {
                Log.ignore((Throwable)e);
            }
            finally {
                if (taglib11 == null) {
                    taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
                }
                if (taglib12 == null) {
                    taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
                }
                if (taglib20 == null) {
                    taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
                }
                if (taglib21 == null) {
                    taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
                }
            }
            if (taglib11 != null) {
                this.redirect(parser, "web-jsptaglib_1_1.dtd", taglib11);
                this.redirect(parser, "web-jsptaglibrary_1_1.dtd", taglib11);
            }
            if (taglib12 != null) {
                this.redirect(parser, "web-jsptaglib_1_2.dtd", taglib12);
                this.redirect(parser, "web-jsptaglibrary_1_2.dtd", taglib12);
            }
            if (taglib20 != null) {
                this.redirect(parser, "web-jsptaglib_2_0.xsd", taglib20);
                this.redirect(parser, "web-jsptaglibrary_2_0.xsd", taglib20);
            }
            if (taglib21 != null) {
                this.redirect(parser, "web-jsptaglib_2_1.xsd", taglib21);
                this.redirect(parser, "web-jsptaglibrary_2_1.xsd", taglib21);
            }
            parser.setXpath("/taglib/listener/listener-class");
            return parser;
        }

        @Override
        public void parse() throws Exception {
            this.ensureParser();
            try {
                this._root = this._parser.parse(this._xml.getInputStream());
            }
            catch (Exception e) {
                this._root = this._parser.parse(this._xml.getURL().toString());
            }
            if (this._root == null) {
                Log.warn((String)"No TLD root in {}", (Object)this._xml);
            }
        }
    }

    public class TldProcessor
    extends IterativeDescriptorProcessor {
        public static final String TAGLIB_PROCESSOR = "org.eclipse.jetty.tagLibProcessor";
        XmlParser _parser;
        List<XmlParser.Node> _roots = new ArrayList<XmlParser.Node>();
        List<EventListener> _listeners = new ArrayList<EventListener>();

        public TldProcessor() throws Exception {
            this.registerVisitor("listener", this.getClass().getDeclaredMethod("visitListener", __signature));
        }

        public void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
            String className = node.getString("listener-class", false, true);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("listener=" + className));
            }
            try {
                Class listenerClass = context.loadClass(className);
                EventListener l = (EventListener)listenerClass.newInstance();
                this._listeners.add(l);
            }
            catch (Exception e) {
                Log.warn((String)("Could not instantiate listener " + className + ": " + e));
                Log.debug((Throwable)e);
            }
            catch (Error e) {
                Log.warn((String)("Could not instantiate listener " + className + ": " + e));
                Log.debug((Throwable)e);
            }
        }

        @Override
        public void end(WebAppContext context, Descriptor descriptor) {
        }

        @Override
        public void start(WebAppContext context, Descriptor descriptor) {
        }

        public List<EventListener> getListeners() {
            return this._listeners;
        }
    }
}

