/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.URI;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SimpleBuffers;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketConnectionD10;
import org.eclipse.jetty.websocket.WebSocketGeneratorD10;

public class WebSocketClient
extends AggregateLifeCycle {
    private static final Logger __log = Log.getLogger((String)WebSocketClient.class.getCanonicalName());
    private static final Random __random = new Random();
    private static final ByteArrayBuffer __ACCEPT = new ByteArrayBuffer.CaseInsensitive("Sec-WebSocket-Accept");
    private final WebSocketClient _root;
    private final WebSocketClient _parent;
    private final ThreadPool _threadPool;
    private final WebSocketClientSelector _selector;
    private final Map<String, String> _cookies = new ConcurrentHashMap<String, String>();
    private final List<String> _extensions = new CopyOnWriteArrayList<String>();
    private int _bufferSize = 65536;
    private String _protocol;
    private int _maxIdleTime = -1;
    private WebSocketBuffers _buffers;

    public WebSocketClient() {
        this((ThreadPool)new QueuedThreadPool());
    }

    public WebSocketClient(ThreadPool threadpool) {
        this._root = this;
        this._parent = null;
        this._threadPool = threadpool;
        this._selector = new WebSocketClientSelector();
        this.addBean((Object)this._selector);
        this.addBean(this._threadPool);
    }

    public WebSocketClient(WebSocketClient parent) {
        this._root = parent._root;
        this._parent = parent;
        this._threadPool = parent._threadPool;
        this._selector = parent._selector;
        this._parent.addBean((Object)this);
    }

    public SelectorManager getSelectorManager() {
        return this._selector;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._bufferSize = bufferSize;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public Map<String, String> getCookies() {
        return this._cookies;
    }

    public List<String> getExtensions() {
        return this._extensions;
    }

    public WebSocket.Connection open(URI uri, WebSocket websocket, long maxConnectTime, TimeUnit units) throws IOException, InterruptedException, TimeoutException {
        try {
            return this.open(uri, websocket).get(maxConnectTime, units);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Future<WebSocket.Connection> open(URI uri, WebSocket websocket) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("!started");
        }
        String scheme = uri.getScheme();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Bad WebSocket scheme '" + scheme + "'");
        }
        if ("wss".equalsIgnoreCase(scheme)) {
            throw new IOException("wss not supported");
        }
        SocketChannel channel = SocketChannel.open();
        channel.socket().setTcpNoDelay(true);
        int maxIdleTime = this.getMaxIdleTime();
        if (maxIdleTime < 0) {
            maxIdleTime = (int)this._selector.getMaxIdleTime();
        }
        if (maxIdleTime > 0) {
            channel.socket().setSoTimeout(maxIdleTime);
        }
        InetSocketAddress address = new InetSocketAddress(uri.getHost(), uri.getPort());
        WebSocketFuture holder = new WebSocketFuture(websocket, uri, this._protocol, maxIdleTime, this._cookies, this._extensions, channel);
        channel.configureBlocking(false);
        channel.connect(address);
        this._selector.register(channel, holder);
        return holder;
    }

    protected void doStart() throws Exception {
        if (this._parent != null && !this._parent.isRunning()) {
            throw new IllegalStateException("parent:" + this.getState());
        }
        this._buffers = new WebSocketBuffers(this._bufferSize);
        super.doStart();
        if (this._parent == null) {
            int i = 0;
            while (i < this._selector.getSelectSets()) {
                final int id = i++;
                this._threadPool.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        while (WebSocketClient.this.isRunning()) {
                            try {
                                WebSocketClient.this._selector.doSelect(id);
                            }
                            catch (IOException e) {
                                __log.warn((Throwable)e);
                            }
                        }
                    }
                });
            }
        }
    }

    class HandshakeConnection
    extends AbstractConnection {
        private final SelectChannelEndPoint _endp;
        private final WebSocketFuture _holder;
        private final String _key;
        private final HttpParser _parser;
        private String _accept;
        private String _error;

        public HandshakeConnection(SelectChannelEndPoint endpoint, WebSocketFuture holder) {
            super((EndPoint)endpoint, System.currentTimeMillis());
            this._endp = endpoint;
            this._holder = holder;
            byte[] bytes = new byte[16];
            __random.nextBytes(bytes);
            this._key = new String(B64Code.encode((byte[])bytes));
            SimpleBuffers buffers = new SimpleBuffers(WebSocketClient.this._buffers.getBuffer(), null);
            this._parser = new HttpParser((Buffers)buffers, (EndPoint)this._endp, new HttpParser.EventHandler(){

                public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
                    if (status != 101) {
                        HandshakeConnection.this._error = "Bad response status " + status + " " + reason;
                        HandshakeConnection.this._endp.close();
                    }
                }

                public void parsedHeader(Buffer name, Buffer value) throws IOException {
                    if (__ACCEPT.equals((Object)name)) {
                        HandshakeConnection.this._accept = value.toString();
                    }
                }

                public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
                    if (HandshakeConnection.this._error == null) {
                        HandshakeConnection.this._error = "Bad response: " + method + " " + url + " " + version;
                    }
                    HandshakeConnection.this._endp.close();
                }

                public void content(Buffer ref) throws IOException {
                    if (HandshakeConnection.this._error == null) {
                        HandshakeConnection.this._error = "Bad response. " + ref.length() + "B of content?";
                    }
                    HandshakeConnection.this._endp.close();
                }
            });
            String path = this._holder.getURI().getPath();
            if (path == null || path.length() == 0) {
                path = "/";
            }
            String request = "GET " + path + " HTTP/1.1\r\n" + "Host: " + holder.getURI().getHost() + ":" + this._holder.getURI().getPort() + "\r\n" + "Upgrade: websocket\r\n" + "Connection: Upgrade\r\n" + "Sec-WebSocket-Key: " + this._key + "\r\n" + "Sec-WebSocket-Origin: http://example.com\r\n" + "Sec-WebSocket-Version: " + 8 + "\r\n";
            if (holder.getProtocol() != null) {
                request = request + "Sec-WebSocket-Protocol: " + holder.getProtocol() + "\r\n";
            }
            if (holder.getCookies() != null && holder.getCookies().size() > 0) {
                for (String cookie : holder.getCookies().keySet()) {
                    request = request + "Cookie: " + QuotedStringTokenizer.quoteIfNeeded((String)cookie, (String)"\"\\\n\r\t\f\b%+ ;=") + "=" + QuotedStringTokenizer.quoteIfNeeded((String)holder.getCookies().get(cookie), (String)"\"\\\n\r\t\f\b%+ ;=") + "\r\n";
                }
            }
            request = request + "\r\n";
            try {
                ByteArrayBuffer handshake = new ByteArrayBuffer(request, false);
                int len = handshake.length();
                if (len != this._endp.flush((Buffer)handshake)) {
                    throw new IOException("incomplete");
                }
            }
            catch (IOException e) {
                holder.handshakeFailed(e);
            }
        }

        public Connection handle() throws IOException {
            while (this._endp.isOpen() && !this._parser.isComplete()) {
                switch (this._parser.parseAvailable()) {
                    case -1: {
                        this._holder.handshakeFailed(new IOException("Incomplete handshake response"));
                        return this;
                    }
                    case 0: {
                        return this;
                    }
                }
            }
            if (this._error == null) {
                if (this._accept == null) {
                    this._error = "No Sec-WebSocket-Accept";
                } else if (!WebSocketConnectionD10.hashKey(this._key).equals(this._accept)) {
                    this._error = "Bad Sec-WebSocket-Accept";
                } else {
                    Buffer header = this._parser.getHeaderBuffer();
                    WebSocketConnectionD10 connection = new WebSocketConnectionD10(this._holder.getWebSocket(), (EndPoint)this._endp, WebSocketClient.this._buffers, System.currentTimeMillis(), this._holder.getMaxIdleTime(), this._holder.getProtocol(), null, 10, new WebSocketGeneratorD10.RandomMaskGen());
                    if (header.hasContent()) {
                        connection.fillBuffersFrom(header);
                    }
                    WebSocketClient.this._buffers.returnBuffer(header);
                    this._holder.onConnection(connection);
                    return connection;
                }
            }
            this._endp.close();
            return this;
        }

        public boolean isIdle() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void closed() {
            if (this._error != null) {
                this._holder.handshakeFailed(new ProtocolException(this._error));
            } else {
                this._holder.handshakeFailed(new EOFException());
            }
        }
    }

    class WebSocketClientSelector
    extends SelectorManager {
        WebSocketClientSelector() {
        }

        public boolean dispatch(Runnable task) {
            return WebSocketClient.this._threadPool.dispatch(task);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return new SelectChannelEndPoint(channel, selectSet, sKey);
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            WebSocketFuture holder = (WebSocketFuture)endpoint.getSelectionKey().attachment();
            return new HandshakeConnection(endpoint, holder);
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            throw new IllegalStateException();
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            endpoint.getConnection().closed();
        }

        protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
            if (!(attachment instanceof WebSocketFuture)) {
                super.connectionFailed(channel, ex, attachment);
            } else {
                __log.debug(ex);
                WebSocketFuture holder = (WebSocketFuture)attachment;
                holder.handshakeFailed(ex);
            }
        }
    }

    class WebSocketFuture
    implements Future<WebSocket.Connection> {
        final WebSocket _websocket;
        final URI _uri;
        final String _protocol;
        final int _maxIdleTime;
        final Map<String, String> _cookies;
        final List<String> _extensions;
        final CountDownLatch _done = new CountDownLatch(1);
        ByteChannel _channel;
        WebSocketConnection _connection;
        Throwable _exception;

        public WebSocketFuture(WebSocket websocket, URI uri, String protocol, int maxIdleTime, Map<String, String> cookies, List<String> extensions, ByteChannel channel) {
            this._websocket = websocket;
            this._uri = uri;
            this._protocol = protocol;
            this._maxIdleTime = maxIdleTime;
            this._cookies = cookies;
            this._extensions = extensions;
            this._channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnection(WebSocketConnection connection) {
            try {
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._channel != null) {
                        this._connection = connection;
                    }
                }
                if (this._connection != null) {
                    if (this._websocket instanceof WebSocket.OnFrame) {
                        ((WebSocket.OnFrame)this._websocket).onHandshake((WebSocket.FrameConnection)connection.getConnection());
                    }
                    this._websocket.onOpen(connection.getConnection());
                }
            }
            finally {
                this._done.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handshakeFailed(Throwable ex) {
            try {
                ByteChannel channel = null;
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._channel != null) {
                        channel = this._channel;
                        this._channel = null;
                        this._exception = ex;
                    }
                }
                if (channel != null) {
                    if (ex instanceof ProtocolException) {
                        this.closeChannel(channel, 1002, ex.getMessage());
                    } else {
                        this.closeChannel(channel, 1006, ex.getMessage());
                    }
                }
            }
            finally {
                this._done.countDown();
            }
        }

        public Map<String, String> getCookies() {
            return this._cookies;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public WebSocket getWebSocket() {
            return this._websocket;
        }

        public URI getURI() {
            return this._uri;
        }

        public int getMaxIdleTime() {
            return this._maxIdleTime;
        }

        public String toString() {
            return "[" + this._uri + "," + this._websocket + "]@" + this.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                ByteChannel channel = null;
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._connection == null && this._exception == null && this._channel != null) {
                        channel = this._channel;
                        this._channel = null;
                    }
                }
                if (channel != null) {
                    this.closeChannel(channel, 1006, "cancelled");
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this._done.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                return this._channel == null && this._connection == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                return this._connection != null && this._exception == null;
            }
        }

        @Override
        public WebSocket.Connection get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("The universe has ended", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebSocket.Connection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this._done.await(timeout, unit);
            ByteChannel channel = null;
            WebSocket.Connection connection = null;
            Throwable exception = null;
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                exception = this._exception;
                if (this._connection == null) {
                    exception = this._exception;
                    channel = this._channel;
                    this._channel = null;
                } else {
                    connection = this._connection.getConnection();
                }
            }
            if (channel != null) {
                this.closeChannel(channel, 1006, "timeout");
            }
            if (exception != null) {
                throw new ExecutionException(exception);
            }
            if (connection != null) {
                return connection;
            }
            throw new TimeoutException();
        }

        private void closeChannel(ByteChannel channel, int code, String message) {
            try {
                this._websocket.onClose(code, message);
            }
            catch (Exception e) {
                __log.warn((Throwable)e);
            }
            try {
                channel.close();
            }
            catch (IOException e) {
                __log.debug((Throwable)e);
            }
        }
    }
}

