/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.providers.ScanningAppProvider;
import org.eclipse.jetty.osgi.boot.AutoStartWhenFrameworkHasCompleted;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class OSGiAppProvider
extends ScanningAppProvider
implements AppProvider {
    private boolean _extractWars = true;
    private boolean _parentLoaderPriority = false;
    private String _defaultsDescriptor;
    private String _tldBundles;
    private String[] _configurationClasses;
    private boolean _autoInstallOSGiBundles = true;
    Set<Bundle> _pendingBundlesToStart = null;

    private static String getDeployedAppName(String contextFileName) {
        String lowername = contextFileName.toLowerCase();
        if (lowername.endsWith(".xml")) {
            String contextName = contextFileName.substring(0, lowername.length() - ".xml".length());
            return contextName;
        }
        return null;
    }

    private String getContextHandlerAppName(ContextHandler context) {
        String appName = context.getDisplayName();
        if (appName == null || appName.length() == 0 || this.getDeployedApps().containsKey(appName)) {
            if (context instanceof WebAppContext) {
                appName = ((WebAppContext)context).getContextPath();
                if (this.getDeployedApps().containsKey(appName)) {
                    appName = "noDisplayName" + context.getClass().getSimpleName() + context.hashCode();
                }
            } else {
                appName = "noDisplayName" + context.getClass().getSimpleName() + context.hashCode();
            }
        }
        return appName;
    }

    public OSGiAppProvider() {
        super((FilenameFilter)new Filter());
        ((Filter)this._filenameFilter)._enclosedInstance = this;
    }

    public OSGiAppProvider(File contextsDir) throws IOException {
        this();
        this.setMonitoredDirResource(Resource.newResource((URI)contextsDir.toURI()));
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        ContextHandler wah = app.getContextHandler();
        if (wah == null) {
            throw new IllegalStateException("The App must be passed the instance of the ContextHandler when it is construsted");
        }
        if (this._configurationClasses != null && wah instanceof WebAppContext) {
            ((WebAppContext)wah).setConfigurationClasses(this._configurationClasses);
        }
        return app.getContextHandler();
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        super.setDeploymentManager(deploymentManager);
    }

    private static String getOriginId(Bundle contributor, String pathInBundle) {
        return contributor.getSymbolicName() + "-" + contributor.getVersion().toString() + (pathInBundle.startsWith("/") ? pathInBundle : "/" + pathInBundle);
    }

    public void addContext(Bundle contributor, String pathInBundle, ContextHandler context) throws Exception {
        this.addContext(OSGiAppProvider.getOriginId(contributor, pathInBundle), context);
    }

    public void addContext(String originId, ContextHandler context) throws Exception {
        if (context instanceof WebAppContext) {
            ((WebAppContext)context).setExtractWAR(this.isExtract());
        }
        App app = new App(this.getDeploymentManager(), (AppProvider)this, originId, context);
        String appName = this.getContextHandlerAppName(context);
        this.getDeployedApps().put(appName, app);
        this.getDeploymentManager().addApp(app);
    }

    protected App createApp(String filename) {
        String name = OSGiAppProvider.getDeployedAppName(filename);
        if (name != null) {
            return (App)this.getDeployedApps().get(name);
        }
        return null;
    }

    public void removeContext(ContextHandler context) throws Exception {
        String appName = this.getContextHandlerAppName(context);
        App app = (App)this.getDeployedApps().remove(context.getDisplayName());
        if (app == null) {
            appName = null;
            for (Map.Entry deployedApp : this.getDeployedApps().entrySet()) {
                if (((App)deployedApp.getValue()).getContextHandler() != context) continue;
                app = (App)deployedApp.getValue();
                appName = (String)deployedApp.getKey();
                break;
            }
            if (appName != null) {
                this.getDeployedApps().remove(appName);
            }
        }
        if (app != null) {
            this.getDeploymentManager().removeApp(app);
        }
    }

    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._parentLoaderPriority = parentLoaderPriority;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public File getContextXmlDirAsFile() {
        try {
            Resource monitoredDir = this.getMonitoredDirResource();
            if (monitoredDir == null) {
                return null;
            }
            return monitoredDir.getFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getContextXmlDir() {
        try {
            Resource monitoredDir = this.getMonitoredDirResource();
            if (monitoredDir == null) {
                return null;
            }
            return monitoredDir.getFile().toURI().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isExtract() {
        return this._extractWars;
    }

    public void setExtract(boolean extract) {
        this._extractWars = extract;
    }

    public boolean isAutoInstallOSGiBundles() {
        return this._autoInstallOSGiBundles;
    }

    public void setAutoInstallOSGiBundles(boolean installingOSGiBundles) {
        this._autoInstallOSGiBundles = installingOSGiBundles;
    }

    public void setContextXmlDir(String contextsDir) {
        this.setMonitoredDirName(contextsDir);
    }

    public void setTldBundles(String tldBundles) {
        this._tldBundles = tldBundles;
    }

    public String getTldBundles() {
        return this._tldBundles;
    }

    public void setConfigurationClasses(String[] configurations) {
        this._configurationClasses = configurations == null ? null : (String[])configurations.clone();
    }

    public String[] getConfigurationClasses() {
        return this._configurationClasses;
    }

    protected void doStart() throws Exception {
        if (this.isAutoInstallOSGiBundles()) {
            if (this.getMonitoredDirResource() == null) {
                this.setAutoInstallOSGiBundles(false);
                Log.info((String)"Disable autoInstallOSGiBundles as there is not contexts folder to monitor.");
            } else {
                File scandir = null;
                try {
                    scandir = this.getMonitoredDirResource().getFile();
                    if (!scandir.exists() || !scandir.isDirectory()) {
                        this.setAutoInstallOSGiBundles(false);
                        Log.warn((String)("Disable autoInstallOSGiBundles as the contexts folder '" + scandir.getAbsolutePath() + " does not exist."));
                        scandir = null;
                    }
                }
                catch (IOException ioe) {
                    this.setAutoInstallOSGiBundles(false);
                    Log.warn((String)("Disable autoInstallOSGiBundles as the contexts folder '" + this.getMonitoredDirResource().getURI() + " does not exist."));
                    scandir = null;
                }
                if (scandir != null) {
                    for (File file : scandir.listFiles()) {
                        if (!OSGiAppProvider.fileMightBeAnOSGiBundle(file)) continue;
                        this.installBundle(file, false);
                    }
                }
            }
        }
        super.doStart();
        if (this.isAutoInstallOSGiBundles()) {
            AutoStartWhenFrameworkHasCompleted scanCycleListner = new AutoStartWhenFrameworkHasCompleted(this);
            super.addScannerListener((Scanner.Listener)scanCycleListner);
        }
    }

    protected void fileAdded(String filename) throws Exception {
        File file = new File(filename);
        if (this.isAutoInstallOSGiBundles() && file.exists() && OSGiAppProvider.fileMightBeAnOSGiBundle(file)) {
            this.installBundle(file, true);
        } else {
            super.fileAdded(filename);
        }
    }

    private static boolean fileMightBeAnOSGiBundle(File file) {
        return file.isDirectory() ? new File(file, "META-INF/MANIFEST.MF").exists() : file.getName().endsWith(".jar");
    }

    protected void fileChanged(String filename) throws Exception {
        File file = new File(filename);
        if (this.isAutoInstallOSGiBundles() && OSGiAppProvider.fileMightBeAnOSGiBundle(file)) {
            this.updateBundle(file);
        } else {
            super.fileChanged(filename);
        }
    }

    protected void fileRemoved(String filename) throws Exception {
        File file = new File(filename);
        if (this.isAutoInstallOSGiBundles() && OSGiAppProvider.fileMightBeAnOSGiBundle(file)) {
            this.uninstallBundle(file);
        } else {
            super.fileRemoved(filename);
        }
    }

    protected Bundle getBundle(BundleContext bc, String location) {
        for (Bundle b : bc.getBundles()) {
            if (!b.getLocation().equals(location)) continue;
            return b;
        }
        return null;
    }

    protected synchronized Bundle installBundle(File file, boolean start) {
        try {
            BundleContext bc = JettyBootstrapActivator.getBundleContext();
            String location = file.toURI().toString();
            Bundle b = this.getBundle(bc, location);
            if (b == null) {
                b = bc.installBundle(location);
            }
            if (b == null) {
                Log.warn((String)("The file " + location + " is not an OSGi bundle."));
                return null;
            }
            if (start && b.getHeaders().get("Fragment-Host") == null) {
                if (!PackageAdminServiceTracker.INSTANCE.frameworkHasCompletedAutostarts()) {
                    if (this._pendingBundlesToStart == null) {
                        this._pendingBundlesToStart = new HashSet<Bundle>();
                    }
                    this._pendingBundlesToStart.add(b);
                    return null;
                }
                b.start();
            }
            return b;
        }
        catch (BundleException e) {
            Log.warn((String)("Unable to " + (start ? "start" : "install") + " the bundle " + file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    protected void uninstallBundle(File file) {
        try {
            Bundle b = this.getBundle(JettyBootstrapActivator.getBundleContext(), file.toURI().toString());
            b.stop();
            b.uninstall();
        }
        catch (BundleException e) {
            Log.warn((String)("Unable to uninstall the bundle " + file.getAbsolutePath()), (Throwable)e);
        }
    }

    protected void updateBundle(File file) {
        try {
            Bundle b = this.getBundle(JettyBootstrapActivator.getBundleContext(), file.toURI().toString());
            if (b == null) {
                this.installBundle(file, true);
            } else if (b.getState() == 32) {
                b.update();
            } else {
                b.start();
            }
        }
        catch (BundleException e) {
            Log.warn((String)("Unable to update the bundle " + file.getAbsolutePath()), (Throwable)e);
        }
    }

    private static class Filter
    implements FilenameFilter {
        OSGiAppProvider _enclosedInstance;

        private Filter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            String contextName;
            File file = new File(dir, name);
            if (OSGiAppProvider.fileMightBeAnOSGiBundle(file)) {
                return true;
            }
            if (!file.isDirectory() && (contextName = OSGiAppProvider.getDeployedAppName(name)) != null) {
                App app = (App)this._enclosedInstance.getDeployedApps().get(contextName);
                return app != null;
            }
            return false;
        }
    }
}

