/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.nosql.NoSqlSession;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class NoSqlSessionManager
extends AbstractSessionManager
implements SessionManager {
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected final ConcurrentMap<String, NoSqlSession> _sessions = new ConcurrentHashMap<String, NoSqlSession>();
    private int _stalePeriod = 0;
    private int _savePeriod = 0;
    private int _idlePeriod = -1;
    private boolean _invalidateOnStop;
    private boolean _saveAllAttributes;

    public void doStart() throws Exception {
        super.doStart();
    }

    protected void addSession(AbstractSession session) {
        if (this.isRunning()) {
            this._sessions.put(session.getClusterId(), (NoSqlSession)session);
        }
    }

    public AbstractSession getSession(String idInCluster) {
        NoSqlSession race;
        NoSqlSession session = (NoSqlSession)((Object)this._sessions.get(idInCluster));
        __log.debug("getSession: " + (Object)((Object)session), new Object[0]);
        if (session == null && (session = this.loadSession(idInCluster)) != null && (race = this._sessions.putIfAbsent(idInCluster, session)) != null) {
            session.willPassivate();
            session.clearAttributes();
            session = race;
        }
        return session;
    }

    protected void invalidateSessions() throws Exception {
        ArrayList sessions = new ArrayList(this._sessions.values());
        int loop = 100;
        while (sessions.size() > 0 && loop-- > 0) {
            if (this.isStopping()) {
                for (NoSqlSession session : sessions) {
                    session.save(false);
                    this.removeSession(session, false);
                }
            } else {
                for (NoSqlSession session : sessions) {
                    session.invalidate();
                }
            }
            sessions = new ArrayList(this._sessions.values());
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        long created = System.currentTimeMillis();
        String clusterId = this.getSessionIdManager().newSessionId(request, created);
        return new NoSqlSession(this, created, created, clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(String idInCluster) {
        NoSqlSessionManager noSqlSessionManager = this;
        synchronized (noSqlSessionManager) {
            NoSqlSession session = (NoSqlSession)((Object)this._sessions.remove(idInCluster));
            try {
                if (session != null) {
                    return this.remove(session);
                }
            }
            catch (Exception e) {
                __log.warn("Problem deleting session id=" + idInCluster, (Throwable)e);
            }
            return session != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateSession(String idInCluster) {
        NoSqlSessionManager noSqlSessionManager = this;
        synchronized (noSqlSessionManager) {
            NoSqlSession session = (NoSqlSession)((Object)this._sessions.remove(idInCluster));
            try {
                if (session != null) {
                    this.remove(session);
                }
            }
            catch (Exception e) {
                __log.warn("Problem deleting session id=" + idInCluster, (Throwable)e);
            }
        }
    }

    public int getStalePeriod() {
        return this._stalePeriod;
    }

    public void setStalePeriod(int stalePeriod) {
        this._stalePeriod = stalePeriod;
    }

    public int getSavePeriod() {
        return this._savePeriod;
    }

    public void setSavePeriod(int savePeriod) {
        this._savePeriod = savePeriod;
    }

    public int getIdlePeriod() {
        return this._idlePeriod;
    }

    public void setIdlePeriod(int idlePeriod) {
        this._idlePeriod = idlePeriod;
    }

    public boolean isInvalidateOnStop() {
        return this._invalidateOnStop;
    }

    public void setInvalidateOnStop(boolean invalidateOnStop) {
        this._invalidateOnStop = invalidateOnStop;
    }

    public boolean isSaveAllAttributes() {
        return this._saveAllAttributes;
    }

    public void setSaveAllAttributes(boolean saveAllAttributes) {
        this._saveAllAttributes = saveAllAttributes;
    }

    protected abstract NoSqlSession loadSession(String var1);

    protected abstract Object save(NoSqlSession var1, Object var2, boolean var3);

    protected abstract Object refresh(NoSqlSession var1, Object var2);

    protected abstract boolean remove(NoSqlSession var1);
}

