/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.eclipse.jetty.jndi.ContextFactory;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Logger;

public class NamingContext
implements Context,
Cloneable,
Dumpable {
    private static final Logger __log = NamingUtil.__log;
    private static final List<Binding> __empty = Collections.emptyList();
    public static final String LOCK_PROPERTY = "org.eclipse.jndi.lock";
    public static final String UNLOCK_PROPERTY = "org.eclipse.jndi.unlock";
    protected final Hashtable<String, Object> _env = new Hashtable();
    protected Map<String, Binding> _bindings = new HashMap<String, Binding>();
    protected NamingContext _parent = null;
    protected String _name = null;
    protected NameParser _parser = null;
    private Collection<Listener> _listeners;

    public NamingContext(Hashtable<String, Object> env, String name, NamingContext parent, NameParser parser) {
        if (env != null) {
            this._env.putAll(env);
        }
        this._name = name;
        this._parent = parent;
        this._parser = parser;
    }

    public NamingContext(Hashtable<String, Object> env) {
        if (env != null) {
            this._env.putAll(env);
        }
    }

    public NamingContext() {
    }

    public Object clone() throws CloneNotSupportedException {
        NamingContext ctx = (NamingContext)super.clone();
        ctx._env.putAll(this._env);
        ctx._bindings.putAll(this._bindings);
        return ctx;
    }

    public String getName() {
        return this._name;
    }

    public Context getParent() {
        return this._parent;
    }

    public void setNameParser(NameParser parser) {
        this._parser = parser;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, this, this._env);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            this.addBinding(cname, objToBind);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = this.getBinding(firstComponent);
                if (binding == null) {
                    throw new NameNotFoundException(firstComponent + " is not bound");
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", (Throwable)e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (ctx instanceof Context) {
                ((Context)ctx).bind(cname.getSuffix(1), obj);
            } else {
                throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
            }
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this._parser.parse(name), obj);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (this.isLocked()) {
            NamingException ne = new NamingException("This context is immutable");
            ne.setRemainingName(name);
            throw ne;
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding != null) {
                throw new NameAlreadyBoundException(cname.toString());
            }
            NamingContext ctx = new NamingContext((Hashtable)this._env.clone(), cname.get(0), this, this._parser);
            this.addBinding(cname, ctx);
            return ctx;
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException(firstComponent + " is not bound");
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                if (__log.isDebugEnabled()) {
                    __log.debug("Object bound at " + firstComponent + " is a Reference", new Object[0]);
                }
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (ctx instanceof Context) {
            return ((Context)ctx).createSubcontext(cname.getSuffix(1));
        }
        throw new NotContextException(firstComponent + " is not a Context");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this._parser.parse(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.removeBinding(this._parser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.removeBinding(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Name cname;
        if (__log.isDebugEnabled()) {
            __log.debug("Looking up name=\"" + name + "\"", new Object[0]);
        }
        if ((cname = this.toCanonicalName(name)) == null || cname.size() == 0) {
            __log.debug("Null or empty name, returning copy of this context", new Object[0]);
            NamingContext ctx = new NamingContext(this._env, this._name, this._parent, this._parser);
            ctx._bindings = this._bindings;
            return ctx;
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding == null) {
                NameNotFoundException nnfe = new NameNotFoundException();
                nnfe.setRemainingName(cname);
                throw nnfe;
            }
            Object o = binding.getObject();
            if (o instanceof LinkRef) {
                String linkName = ((LinkRef)o).getLinkName();
                if (linkName.startsWith("./")) {
                    return this.lookup(linkName.substring(2));
                }
                InitialContext ictx = new InitialContext();
                return ictx.lookup(linkName);
            }
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname, this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
            return o;
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                NameNotFoundException nnfe = new NameNotFoundException();
                nnfe.setRemainingName(cname);
                throw nnfe;
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).lookup(cname.getSuffix(1));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this._parser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            NamingContext ctx = new NamingContext(this._env, this._name, this._parent, this._parser);
            ctx._bindings = this._bindings;
            return ctx;
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = this.getBinding(cname);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            Object o = binding.getObject();
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname.getPrefix(1), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
            return o;
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).lookup(cname.getSuffix(1));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this._parser.parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Name cname;
        if (__log.isDebugEnabled()) {
            __log.debug("list() on Context=" + this.getName() + " for name=" + name, new Object[0]);
        }
        if ((cname = this.toCanonicalName(name)) == null) {
            return new NameEnumeration(__empty.iterator());
        }
        if (cname.size() == 0) {
            return new NameEnumeration(this._bindings.values().iterator());
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                if (__log.isDebugEnabled()) {
                    __log.debug("Dereferencing Reference for " + name.get(0), new Object[0]);
                }
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).list(cname.getSuffix(1));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this._parser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            return new BindingEnumeration(__empty.iterator());
        }
        if (cname.size() == 0) {
            return new BindingEnumeration(this._bindings.values().iterator());
        }
        String firstComponent = cname.get(0);
        Object ctx = null;
        if (firstComponent.equals("")) {
            ctx = this;
        } else {
            Binding binding = this.getBinding(firstComponent);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            ctx = binding.getObject();
            if (ctx instanceof Reference) {
                try {
                    ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    __log.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
        }
        if (!(ctx instanceof Context)) {
            throw new NotContextException();
        }
        return ((Context)ctx).listBindings(cname.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this._parser.parse(name));
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, this, this._env);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            this.removeBinding(cname);
            this.addBinding(cname, objToBind);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = this.getBinding(name.get(0));
                if (binding == null) {
                    throw new NameNotFoundException(name.get(0) + " is not bound");
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", (Throwable)e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (ctx instanceof Context) {
                ((Context)ctx).rebind(cname.getSuffix(1), obj);
            } else {
                throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this._parser.parse(name), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this._parser.parse(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            return;
        }
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = this.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            this.removeBinding(cname);
        } else {
            if (__log.isDebugEnabled()) {
                __log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = this.getBinding(name.get(0));
                if (binding == null) {
                    throw new NameNotFoundException(name.get(0) + " is not bound");
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", (Throwable)e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (ctx instanceof Context) {
                ((Context)ctx).unbind(cname.getSuffix(1));
            } else {
                throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
            }
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null) {
            throw new NamingException("Name cannot be null");
        }
        if (prefix == null) {
            throw new NamingException("Prefix cannot be null");
        }
        CompoundName compoundName = (CompoundName)prefix.clone();
        compoundName.addAll(name);
        return compoundName;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        if (name == null) {
            throw new NamingException("Name cannot be null");
        }
        if (prefix == null) {
            throw new NamingException("Prefix cannot be null");
        }
        Name compoundName = this._parser.parse(prefix);
        compoundName.add(name);
        return compoundName.toString();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public NameParser getNameParser(Name name) {
        return this._parser;
    }

    @Override
    public NameParser getNameParser(String name) {
        return this._parser;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        Name name = this._parser.parse("");
        for (NamingContext c = this; c != null; c = (NamingContext)c.getParent()) {
            String str = c.getName();
            if (str == null) continue;
            name.add(0, str);
        }
        return name.toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.isLocked() && !propName.equals(UNLOCK_PROPERTY)) {
            throw new NamingException("This context is immutable");
        }
        return this._env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        return this._env.remove(propName);
    }

    public Hashtable getEnvironment() {
        return (Hashtable)this._env.clone();
    }

    protected void addBinding(Name name, Object obj) throws NameAlreadyBoundException {
        Listener listener;
        String key = name.toString();
        Binding binding = new Binding(key, obj);
        Collection<Listener> list = this.findListeners();
        Iterator<Listener> i$ = list.iterator();
        while (i$.hasNext() && (binding = (listener = i$.next()).bind(this, binding)) != null) {
        }
        if (__log.isDebugEnabled()) {
            __log.debug("Adding binding with key=" + key + " obj=" + obj + " for context=" + this._name + " as " + binding, new Object[0]);
        }
        if (binding != null) {
            if (this._bindings.containsKey(key)) {
                throw new NameAlreadyBoundException(name.toString());
            }
            this._bindings.put(key, binding);
        }
    }

    protected Binding getBinding(Name name) {
        return this._bindings.get(name.toString());
    }

    protected Binding getBinding(String name) {
        return this._bindings.get(name);
    }

    protected void removeBinding(Name name) {
        Binding binding;
        String key = name.toString();
        if (__log.isDebugEnabled()) {
            __log.debug("Removing binding with key=" + key, new Object[0]);
        }
        if ((binding = this._bindings.remove(key)) != null) {
            Collection<Listener> list = this.findListeners();
            for (Listener listener : list) {
                listener.unbind(this, binding);
            }
        }
    }

    public Name toCanonicalName(Name name) {
        Name canonicalName = name;
        if (name != null && canonicalName.size() > 1) {
            if (canonicalName.get(0).equals("")) {
                canonicalName = canonicalName.getSuffix(1);
            }
            if (canonicalName.get(canonicalName.size() - 1).equals("")) {
                canonicalName = canonicalName.getPrefix(canonicalName.size() - 1);
            }
        }
        return canonicalName;
    }

    private boolean isLocked() {
        if (this._env.get(LOCK_PROPERTY) == null && this._env.get(UNLOCK_PROPERTY) == null) {
            return false;
        }
        Object lockKey = this._env.get(LOCK_PROPERTY);
        Object unlockKey = this._env.get(UNLOCK_PROPERTY);
        return lockKey == null || unlockKey == null || !lockKey.equals(unlockKey);
    }

    public String dump() {
        StringBuilder buf = new StringBuilder();
        try {
            this.dump(buf, "");
        }
        catch (Exception e) {
            __log.warn((Throwable)e);
        }
        return buf.toString();
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.getClass().getSimpleName()).append("@").append(Long.toHexString(this.hashCode())).append("\n");
        int size = this._bindings.size();
        int i = 0;
        for (Map.Entry<String, Binding> entry : this._bindings.entrySet()) {
            boolean last = ++i == size;
            out.append(indent).append(" +- ").append(entry.getKey()).append(": ");
            Binding binding = entry.getValue();
            Object value = binding.getObject();
            if ("comp".equals(entry.getKey()) && value instanceof Reference && "org.eclipse.jetty.jndi.ContextFactory".equals(((Reference)value).getFactoryClassName())) {
                ContextFactory.dump(out, indent + (last ? "    " : " |  "));
                continue;
            }
            if (value instanceof Dumpable) {
                ((Dumpable)value).dump(out, indent + (last ? "    " : " |  "));
                continue;
            }
            out.append(value.getClass().getSimpleName()).append("=");
            out.append(String.valueOf(value).replace('\n', '|').replace('\r', '|'));
            out.append("\n");
        }
    }

    private Collection<Listener> findListeners() {
        ArrayList<Listener> list = new ArrayList<Listener>();
        for (NamingContext ctx = this; ctx != null; ctx = (NamingContext)ctx.getParent()) {
            if (ctx._listeners == null) continue;
            list.addAll(ctx._listeners);
        }
        return list;
    }

    public void addListener(Listener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<Listener>();
        }
        this._listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this._listeners.remove(listener);
    }

    public class BindingEnumeration
    implements NamingEnumeration<Binding> {
        Iterator<Binding> _delegate;

        public BindingEnumeration(Iterator<Binding> e) {
            this._delegate = e;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this._delegate.hasNext();
        }

        @Override
        public Binding next() throws NamingException {
            Binding b = this._delegate.next();
            return new Binding(b.getName(), b.getClassName(), b.getObject(), true);
        }

        @Override
        public boolean hasMoreElements() {
            return this._delegate.hasNext();
        }

        @Override
        public Binding nextElement() {
            Binding b = this._delegate.next();
            return new Binding(b.getName(), b.getClassName(), b.getObject(), true);
        }
    }

    public static interface Listener {
        public Binding bind(NamingContext var1, Binding var2);

        public void unbind(NamingContext var1, Binding var2);
    }

    public class NameEnumeration
    implements NamingEnumeration<NameClassPair> {
        Iterator<Binding> _delegate;

        public NameEnumeration(Iterator<Binding> e) {
            this._delegate = e;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this._delegate.hasNext();
        }

        @Override
        public NameClassPair next() throws NamingException {
            Binding b = this._delegate.next();
            return new NameClassPair(b.getName(), b.getClassName(), true);
        }

        @Override
        public boolean hasMoreElements() {
            return this._delegate.hasNext();
        }

        @Override
        public NameClassPair nextElement() {
            Binding b = this._delegate.next();
            return new NameClassPair(b.getName(), b.getClassName(), true);
        }
    }
}

