/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class MappedLoginService
extends AbstractLifeCycle
implements LoginService {
    protected IdentityService _identityService = new DefaultIdentityService();
    protected String _name;
    protected final ConcurrentMap<String, UserIdentity> _users = new ConcurrentHashMap<String, UserIdentity>();

    protected MappedLoginService() {
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public ConcurrentMap<String, UserIdentity> getUsers() {
        return this._users;
    }

    @Override
    public void setIdentityService(IdentityService identityService) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._identityService = identityService;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._name = name;
    }

    public void setUsers(Map<String, UserIdentity> users) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._users.clear();
        this._users.putAll(users);
    }

    protected void doStart() throws Exception {
        this.loadUsers();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void logout(UserIdentity identity) {
        Log.debug((String)"logout {}", (Object)identity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }

    protected synchronized UserIdentity putUser(String userName, Object info) {
        UserIdentity identity;
        if (info instanceof UserIdentity) {
            identity = (UserIdentity)info;
        } else {
            Credential credential = info instanceof Credential ? (Credential)info : Credential.getCredential((String)info.toString());
            KnownUser userPrincipal = new KnownUser(userName, credential);
            Subject subject = new Subject();
            subject.getPrincipals().add(userPrincipal);
            subject.getPrivateCredentials().add(credential);
            subject.setReadOnly();
            identity = this._identityService.newUserIdentity(subject, userPrincipal, IdentityService.NO_ROLES);
        }
        this._users.put(userName, identity);
        return identity;
    }

    public synchronized UserIdentity putUser(String userName, Credential credential, String[] roles) {
        KnownUser userPrincipal = new KnownUser(userName, credential);
        Subject subject = new Subject();
        subject.getPrincipals().add(userPrincipal);
        subject.getPrivateCredentials().add(credential);
        if (roles != null) {
            for (String role : roles) {
                subject.getPrincipals().add(new RolePrincipal(role));
            }
        }
        subject.setReadOnly();
        UserIdentity identity = this._identityService.newUserIdentity(subject, userPrincipal, roles);
        this._users.put(userName, identity);
        return identity;
    }

    public void removeUser(String username) {
        this._users.remove(username);
    }

    @Override
    public UserIdentity login(String username, Object credentials) {
        UserPrincipal principal;
        UserIdentity user = (UserIdentity)this._users.get(username);
        if (user == null) {
            user = this.loadUser(username);
        }
        if (user != null && (principal = (UserPrincipal)user.getUserPrincipal()).authenticate(credentials)) {
            return user;
        }
        return null;
    }

    @Override
    public boolean validate(UserIdentity user) {
        if (this._users.containsKey(user.getUserPrincipal().getName())) {
            return true;
        }
        return this.loadUser(user.getUserPrincipal().getName()) != null;
    }

    protected abstract UserIdentity loadUser(String var1);

    protected abstract void loadUsers() throws IOException;

    public static class Anonymous
    implements UserPrincipal,
    Serializable {
        private static final long serialVersionUID = 1097640442553284845L;

        @Override
        public boolean isAuthenticated() {
            return false;
        }

        @Override
        public String getName() {
            return "Anonymous";
        }

        @Override
        public boolean authenticate(Object credentials) {
            return false;
        }
    }

    public static class KnownUser
    implements UserPrincipal,
    Serializable {
        private static final long serialVersionUID = -6226920753748399662L;
        private final String _name;
        private final Credential _credential;

        public KnownUser(String name, Credential credential) {
            this._name = name;
            this._credential = credential;
        }

        @Override
        public boolean authenticate(Object credentials) {
            return this._credential != null && this._credential.check(credentials);
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public boolean isAuthenticated() {
            return true;
        }

        @Override
        public String toString() {
            return this._name;
        }
    }

    public static class RolePrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 2998397924051854402L;
        private final String _roleName;

        public RolePrincipal(String name) {
            this._roleName = name;
        }

        @Override
        public String getName() {
            return this._roleName;
        }
    }

    public static interface UserPrincipal
    extends Principal,
    Serializable {
        public boolean authenticate(Object var1);

        public boolean isAuthenticated();
    }
}

