/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD06;
import org.eclipse.jetty.websocket.WebSocketGenerator;

public class WebSocketGeneratorD06
implements WebSocketGenerator {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private Buffer _buffer;
    private final byte[] _mask = new byte[4];
    private int _m;
    private boolean _opsent;
    private final MaskGen _maskGen;

    public WebSocketGeneratorD06(WebSocketBuffers buffers, EndPoint endp) {
        this._buffers = buffers;
        this._endp = endp;
        this._maskGen = null;
    }

    public WebSocketGeneratorD06(WebSocketBuffers buffers, EndPoint endp, MaskGen maskGen) {
        this._buffers = buffers;
        this._endp = endp;
        this._maskGen = maskGen;
    }

    @Override
    public synchronized void addFrame(byte flags, byte opcode, byte[] content, int offset, int length, int blockFor) throws IOException {
        int payload;
        if (this._buffer == null) {
            this._buffer = this._maskGen != null ? this._buffers.getBuffer() : this._buffers.getDirectBuffer();
        }
        boolean last = WebSocketConnectionD06.isLastFrame(flags);
        opcode = (byte)(((0xF & flags) << 4) + 15 & opcode);
        int space = this._maskGen != null ? 14 : 10;
        do {
            int chunk;
            opcode = this._opsent ? (byte)0 : opcode;
            this._opsent = true;
            payload = length;
            if (payload + space > this._buffer.capacity()) {
                opcode = (byte)(opcode & 0x7F);
                payload = this._buffer.capacity() - space;
            } else if (last) {
                opcode = (byte)(opcode | 0xFFFFFF80);
            }
            if (this._buffer.space() <= space) {
                this.expelBuffer(blockFor);
            }
            if (this._maskGen != null) {
                this._maskGen.genMask(this._mask);
                this._m = 0;
                this._buffer.put(this._mask);
            }
            if (payload > 65535) {
                this.bufferPut(new byte[]{opcode, 127, (byte)(payload >> 56 & 0x7F), (byte)(payload >> 48 & 0xFF), (byte)(payload >> 40 & 0xFF), (byte)(payload >> 32 & 0xFF), (byte)(payload >> 24 & 0xFF), (byte)(payload >> 16 & 0xFF), (byte)(payload >> 8 & 0xFF), (byte)(payload & 0xFF)});
            } else if (payload >= 126) {
                this.bufferPut(new byte[]{opcode, 126, (byte)(payload >> 8), (byte)(payload & 0xFF)});
            } else {
                this.bufferPut(opcode);
                this.bufferPut((byte)payload);
            }
            for (int remaining = payload; remaining > 0; remaining -= chunk) {
                this._buffer.compact();
                int n = chunk = remaining < this._buffer.space() ? remaining : this._buffer.space();
                if (this._maskGen != null) {
                    for (int i = 0; i < chunk; ++i) {
                        this.bufferPut(content[offset + (payload - remaining) + i]);
                    }
                } else {
                    this._buffer.put(content, offset + (payload - remaining), chunk);
                }
                if (this._buffer.space() > 0) {
                    this.flushBuffer();
                    continue;
                }
                this.expelBuffer(blockFor);
                if (remaining != 0) continue;
                this.flushBuffer();
            }
            offset += payload;
        } while ((length -= payload) > 0);
        this._opsent = !last;
    }

    private synchronized void bufferPut(byte[] data) throws IOException {
        if (this._maskGen != null) {
            int i = 0;
            while (i < data.length) {
                int n = i++;
                data[n] = (byte)(data[n] ^ this._mask[this._m++ % 4]);
            }
        }
        this._buffer.put(data);
    }

    private synchronized void bufferPut(byte data) throws IOException {
        this._buffer.put((byte)(data ^ this._mask[this._m++ % 4]));
    }

    @Override
    public synchronized int flush(int blockFor) throws IOException {
        return this.expelBuffer(blockFor);
    }

    @Override
    public synchronized int flush() throws IOException {
        int flushed = this.flushBuffer();
        if (this._buffer != null && this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
        return flushed;
    }

    private synchronized int flushBuffer() throws IOException {
        if (!this._endp.isOpen()) {
            throw new EofException();
        }
        if (this._buffer != null) {
            return this._endp.flush(this._buffer);
        }
        return 0;
    }

    private synchronized int expelBuffer(long blockFor) throws IOException {
        if (this._buffer == null) {
            return 0;
        }
        int result = this.flushBuffer();
        this._buffer.compact();
        if (!this._endp.isBlocking()) {
            while (this._buffer.space() == 0) {
                boolean ready = this._endp.blockWritable(blockFor);
                if (!ready) {
                    throw new IOException("Write timeout");
                }
                result += this.flushBuffer();
                this._buffer.compact();
            }
        }
        return result;
    }

    @Override
    public synchronized boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }

    public static class FixedMaskGen
    implements MaskGen {
        final byte[] _mask;

        public FixedMaskGen() {
            this._mask = new byte[]{-1, -1, -1, -1};
        }

        public FixedMaskGen(byte[] mask) {
            this._mask = mask;
        }

        @Override
        public void genMask(byte[] mask) {
            mask[0] = this._mask[0];
            mask[1] = this._mask[1];
            mask[2] = this._mask[2];
            mask[3] = this._mask[3];
        }
    }

    public static interface MaskGen {
        public void genMask(byte[] var1);
    }

    public static class NullMaskGen
    implements MaskGen {
        @Override
        public void genMask(byte[] mask) {
            mask[3] = 0;
            mask[2] = 0;
            mask[1] = 0;
            mask[0] = 0;
        }
    }

    public static class RandomMaskGen
    implements MaskGen {
        final Random _random;

        public RandomMaskGen() {
            this._random = new SecureRandom();
        }

        public RandomMaskGen(Random random) {
            this._random = random;
        }

        @Override
        public void genMask(byte[] mask) {
            this._random.nextBytes(mask);
        }
    }
}

