/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.configurator.service.provider.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rtp.configurator.service.provider.internal.ProviderActivator;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.FeatureInstallException;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.FeatureManager;
import org.eclipse.rtp.configurator.service.provider.internal.deploy.RepositoryManager;
import org.eclipse.rtp.configurator.service.provider.internal.util.P2Util;
import org.eclipse.rtp.core.IRTPService;
import org.eclipse.rtp.core.model.Source;
import org.eclipse.rtp.core.model.SourceVersion;
import org.eclipse.rtp.core.util.ModelUtil;

public class RTPDefaultService
implements IRTPService {
    private P2Util p2Util;

    public void setUp() {
        this.setP2Util(new P2Util());
    }

    public void shutDown() {
        this.setP2Util(null);
    }

    public void setP2Util(P2Util p2Util) {
        this.p2Util = p2Util;
    }

    public IStatus install(SourceVersion sourceVersion) {
        IStatus result = null;
        try {
            if (sourceVersion != null) {
                System.out.println("Loading repository: " + sourceVersion.getRepositoryUrl());
                this.loadRepository(sourceVersion);
                System.out.println("Repository loaded: " + sourceVersion.getRepositoryUrl());
                System.out.println("Installation started");
                this.installVersion(sourceVersion);
                System.out.println("Installaiton successful");
                result = Status.OK_STATUS;
            } else {
                System.out.println("No source found to install");
                result = Status.CANCEL_STATUS;
            }
        }
        catch (Exception e) {
            System.out.println("Feature will not be installed");
            e.printStackTrace();
            result = new Status(4, ProviderActivator.BUNDLE_ID, "Failed to isntall features", (Throwable)e);
        }
        return result;
    }

    private void installVersion(SourceVersion sourceVersion) throws FeatureInstallException {
        FeatureManager featureManager = this.p2Util.getFeatureManager();
        featureManager.installFeature(sourceVersion);
    }

    private void loadRepository(SourceVersion sourceVersion) throws URISyntaxException {
        if (sourceVersion.getRepositoryUrl() != null) {
            RepositoryManager repositoryManager = this.p2Util.getRepositoryManager();
            repositoryManager.addRepository(new URI(sourceVersion.getRepositoryUrl()));
        }
    }

    public IStatus remove(List<SourceVersion> sourceVersionsToUnisntall) {
        FeatureManager featureManager = this.p2Util.getFeatureManager();
        List<IStatus> errorStatus = this.uninstall(featureManager, sourceVersionsToUnisntall);
        return errorStatus.isEmpty() ? Status.OK_STATUS : new MultiStatus(ProviderActivator.BUNDLE_ID, 0, errorStatus.toArray(new IStatus[0]), "Uinstall status", null);
    }

    private List<IStatus> uninstall(FeatureManager featureManager, List<SourceVersion> sourceVersionsToUnisntall) {
        ArrayList<IStatus> errorStatus = new ArrayList<IStatus>();
        for (SourceVersion sourceVersion : sourceVersionsToUnisntall) {
            try {
                featureManager.uninstallFeature(sourceVersion);
            }
            catch (FeatureInstallException e) {
                System.out.println("Failed to uninstall source version: " + sourceVersion.toString());
                e.printStackTrace();
                Status status = new Status(4, ProviderActivator.BUNDLE_ID, "Failed to uninstall source version: " + sourceVersion.toString(), (Throwable)e);
                errorStatus.add((IStatus)status);
            }
        }
        return errorStatus;
    }

    public List<String> search(List<String> anyListOf) {
        List sources = ModelUtil.getSourceProvider().getSources();
        List<Source> result = this.searchSources(sources, anyListOf);
        return this.sourcesToStringSorted(result, false);
    }

    public List<String> show(List<String> anyListOf) {
        List sources = ModelUtil.getSourceProvider().getSources();
        ArrayList<String> showSource = new ArrayList<String>();
        showSource.add(anyListOf.get(0));
        List<Source> result = this.searchSources(sources, showSource);
        return this.sourcesToStringSorted(result, false);
    }

    public List<String> list() throws CoreException {
        List sources = ModelUtil.getSourceProvider().getSources();
        List<String> sourcesAsString = this.sourcesToStringSorted(sources, true);
        return sourcesAsString;
    }

    public void addRepository(URI repository) {
        this.p2Util.getRepositoryManager().addRepository(repository);
    }

    public void removeRepository(URI repository) {
        this.p2Util.getRepositoryManager().removeRepository(repository);
    }

    public IStatus update(List<String> anyListOf) {
        List sources = ModelUtil.getSourceProvider().getSources();
        System.out.println("Searching for updates");
        List<Source> sourceToUpdate = this.searchSources(sources, anyListOf);
        System.out.println("Update started");
        IStatus result = this.updateSources(sourceToUpdate);
        System.out.println("Update successful");
        return result;
    }

    public URI[] getRepositories() {
        return this.p2Util.getRepositoryManager().getRepositories();
    }

    protected List<Source> searchSources(List<Source> sources, List<String> showSource) {
        List result = new ModelUtil().searchSources(showSource, sources);
        return result;
    }

    public IStatus updateWorld() {
        List sources = ModelUtil.getSourceProvider().getSources();
        System.out.println("Update started");
        IStatus result = this.updateSources(sources);
        System.out.println("Update successful");
        return result;
    }

    private IStatus updateSources(List<Source> sources) {
        ArrayList<IStatus> updateStatusList = new ArrayList<IStatus>();
        FeatureManager featureManager = this.p2Util.getFeatureManager();
        for (Source source : sources) {
            List versions = source.getVersions();
            Collections.sort(versions, new ModelUtil().getSourceVersionComparator());
            SourceVersion latestSourceVersion = (SourceVersion)versions.get(0);
            if (featureManager.isInstalled(latestSourceVersion)) continue;
            System.out.println("Updating feature: " + source.getName());
            updateStatusList.addAll(this.uninstall(featureManager, versions));
            updateStatusList.add(this.install(latestSourceVersion));
        }
        MultiStatus result = new MultiStatus(ProviderActivator.BUNDLE_ID, 0, updateStatusList.toArray(new IStatus[0]), "Update status", null);
        return result;
    }

    private List<String> sourcesToStringSorted(List<Source> sources, boolean addInstalledInfo) {
        List<String> sourcesAsString = this.sourcesToString(sources, addInstalledInfo);
        return sourcesAsString;
    }

    protected List<String> sourcesToString(List<Source> sources, boolean addInstalledInfo) {
        Collections.sort(sources, new ModelUtil().getSourceComparator());
        ArrayList<String> sourcesAsString = new ArrayList<String>();
        for (Source source : sources) {
            sourcesAsString.add(source.toString());
            List<String> versionsToString = this.versionsToString(source, addInstalledInfo);
            sourcesAsString.addAll(versionsToString);
        }
        return sourcesAsString;
    }

    private List<String> versionsToString(Source source, boolean addInstalledInfo) {
        List versions = source.getVersions();
        Collections.sort(versions, new ModelUtil().getSourceVersionComparator());
        ArrayList<String> result = new ArrayList<String>();
        for (SourceVersion sourceVersion : versions) {
            if (addInstalledInfo) {
                String installedInfo = this.getInstallInfo(sourceVersion);
                result.add(installedInfo);
            }
            result.add(sourceVersion.toString());
        }
        return result;
    }

    private String getInstallInfo(SourceVersion sourceVersion) {
        FeatureManager featureManager = this.p2Util.getFeatureManager();
        boolean installed = featureManager.isInstalled(sourceVersion);
        String installedInfo = installed ? "[installed]" : "[not installed]";
        return installedInfo;
    }
}

