/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.advanced.STextEnvironment;
import org.eclipse.equinox.bidi.advanced.STextExpertFactory;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;

public final class STextProcessor {
    private static final String defaultSeparators = ".:/\\";
    private static final char LRM = '\u200e';
    private static final char LRE = '\u202a';
    private static final char RLE = '\u202b';
    private static final char PDF = '\u202c';

    private STextProcessor() {
    }

    public static String process(String str) {
        return STextProcessor.process(str, defaultSeparators);
    }

    public static String process(String str, String separators) {
        char c;
        if (str == null || str.length() <= 1) {
            return str;
        }
        if (str.charAt(0) == '\u202a' && str.charAt(str.length() - 1) == '\u202c') {
            return str;
        }
        STextEnvironment env = new STextEnvironment(null, false, 4);
        if (!env.isProcessingNeeded()) {
            return str;
        }
        boolean isStringBidi = false;
        int strLength = str.length();
        int i = 0;
        while (i < strLength) {
            c = str.charAt(i);
            if (c >= '\u05d0' && c <= '\u07b1' || c >= '\ufb1d' && c <= '\ufefc') {
                isStringBidi = true;
                break;
            }
            ++i;
        }
        if (!isStringBidi && Character.isLetter(str.charAt(0)) && (Character.isDigit(c = str.charAt(strLength - 1)) || Character.isLetter(c))) {
            return str;
        }
        if (separators == null) {
            separators = defaultSeparators;
        }
        STextTypeHandler handler = new STextTypeHandler(separators);
        ISTextExpert expert = STextExpertFactory.getStatefulExpert(handler, env);
        return expert.leanToFullText(str);
    }

    public static String processTyped(String str, String textType) {
        if (str == null || str.length() <= 1) {
            return str;
        }
        char c = str.charAt(0);
        if ((c == '\u202a' || c == '\u202b') && str.charAt(str.length() - 1) == '\u202c') {
            return str;
        }
        STextEnvironment env = new STextEnvironment(null, false, 4);
        if (!env.isProcessingNeeded()) {
            return str;
        }
        ISTextExpert expert = STextExpertFactory.getExpert(textType, env);
        return expert.leanToFullText(str);
    }

    public static String deprocess(String str) {
        if (str == null || str.length() <= 1) {
            return str;
        }
        STextEnvironment env = new STextEnvironment(null, false, 4);
        if (!env.isProcessingNeeded()) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            char c = str.charAt(i);
            switch (c) {
                case '\u200e': {
                    break;
                }
                case '\u202a': {
                    break;
                }
                case '\u202c': {
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String deprocessTyped(String str, String textType) {
        if (str == null || str.length() <= 1) {
            return str;
        }
        STextEnvironment env = new STextEnvironment(null, false, 4);
        if (!env.isProcessingNeeded()) {
            return str;
        }
        ISTextExpert expert = STextExpertFactory.getExpert(textType, env);
        return expert.fullToLeanText(str);
    }

    public static String getDefaultSeparators() {
        return defaultSeparators;
    }
}

