/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final long _timeStamp;
    protected final EndPoint _endp;

    public AbstractConnection(EndPoint endp) {
        this._endp = endp;
        this._timeStamp = System.currentTimeMillis();
    }

    public AbstractConnection(EndPoint endp, long timestamp) {
        this._endp = endp;
        this._timeStamp = timestamp;
    }

    @Override
    public long getTimeStamp() {
        return this._timeStamp;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    @Override
    public void onIdleExpired() {
        try {
            LOG.debug("onIdleExpired {} {}", new Object[]{this, this._endp});
            if (this._endp.isInputShutdown() || this._endp.isOutputShutdown()) {
                this._endp.close();
            } else {
                this._endp.shutdownOutput();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                LOG.ignore((Throwable)e2);
            }
        }
    }

    public String toString() {
        return String.format("%s@%x//%s:%d<->%s:%d", this.getClass().getSimpleName(), this.hashCode(), this._endp.getLocalAddr(), this._endp.getLocalPort(), this._endp.getRemoteAddr(), this._endp.getRemotePort());
    }
}

