/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    int modelHandle;
    static final int TEXT_COLUMN = 0;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(14);
        }
        OS.gtk_list_store_append(this.modelHandle, iter);
        OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(14);
        }
        if (index == count) {
            OS.gtk_list_store_append(this.modelHandle, iter);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, iter, index);
        }
        OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    void createHandle(int index) {
        int columnHandle;
        int textRenderer;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = new int[]{OS.G_TYPE_STRING()};
        this.modelHandle = OS.gtk_list_store_newv(types.length, types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((textRenderer = OS.gtk_cell_renderer_text_new()) == 0) {
            this.error(2);
        }
        if ((columnHandle = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        OS.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
        OS.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, 0);
        OS.gtk_tree_view_column_set_min_width(columnHandle, 0);
        OS.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(selectionHandle, mode);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.getShell().style & 0x4000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        OS.gtk_tree_selection_unselect_iter(selection, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start < 0 && end < 0) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (start >= count && end >= count) {
            return;
        }
        start = Math.min(count - 1, Math.max(0, start));
        end = Math.min(count - 1, Math.max(0, end));
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = start;
        while (index <= end) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            OS.gtk_tree_selection_unselect_iter(selection, iter);
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index <= count - 1) {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                OS.gtk_tree_selection_unselect_iter(selection, iter);
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void deselectAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean dragDetect;
        boolean selected = false;
        if (filter) {
            int[] path = new int[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                if (path[0] != 0) {
                    int selection = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                        selected = true;
                    }
                    OS.gtk_tree_path_free(path[0]);
                }
            } else {
                return false;
            }
        }
        if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
            consume[0] = true;
        }
        return dragDetect;
    }

    int eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getFocusIndex() {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0) {
            return -1;
        }
        int indices = OS.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[]{-1};
        if (indices != 0) {
            OS.memmove(index, indices, 4);
        }
        OS.gtk_tree_path_free(path[0]);
        return index[0];
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int[] ptr = new int[1];
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        OS.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
        OS.g_free(iter);
        if (ptr[0] == 0) {
            return null;
        }
        int length = OS.strlen(ptr[0]);
        byte[] buffer2 = new byte[length];
        OS.memmove(buffer2, ptr[0], length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer2));
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int column = OS.gtk_tree_view_get_column(this.handle, 0);
        if (itemCount == 0) {
            int[] w = new int[1];
            int[] h = new int[1];
            OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            return h[0];
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
        OS.g_free(iter);
        return h[0];
    }

    public String[] getItems() {
        this.checkWidget();
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int[] ptr = new int[1];
        String[] result = new String[count];
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int index = 0;
        while (index < count) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            OS.gtk_tree_model_get(this.modelHandle, iter, 0, ptr, -1);
            if (ptr[0] != 0) {
                int length = OS.strlen(ptr[0]);
                byte[] buffer = new byte[length];
                OS.memmove(buffer, ptr[0], length);
                OS.g_free(ptr[0]);
                result[index] = new String(Converter.mbcsToWcs(null, buffer));
            }
            ++index;
        }
        OS.g_free(iter);
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = null;
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            return this.display.treeSelectionLength;
        }
        return OS.gtk_tree_selection_count_selected_rows(selection);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[itemCount];
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == 0) {
                return -1;
            }
            return this.display.treeSelection[0];
        }
        int[] model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null;
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model);
        if (list != 0) {
            int count = OS.g_list_length(list);
            int[] index = new int[1];
            int i = 0;
            while (i < count) {
                int data = OS.g_list_nth_data(list, i);
                int indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0) {
                    OS.memmove(index, indices, 4);
                    break;
                }
                ++i;
            }
            OS.g_list_free(list);
            return index[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            int itemCount = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[itemCount];
            OS.gtk_tree_selection_selected_foreach(selection, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == this.display.treeSelection.length) {
                return this.display.treeSelection;
            }
            int[] result = new int[this.display.treeSelectionLength];
            System.arraycopy(this.display.treeSelection, 0, result, 0, this.display.treeSelectionLength);
            return result;
        }
        int[] model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null;
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model);
        if (list != 0) {
            int count = OS.g_list_length(list);
            int[] treeSelection = new int[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                int data = OS.g_list_nth_data(list, i);
                int indices = OS.gtk_tree_path_get_indices(data);
                if (indices != 0) {
                    int[] index = new int[1];
                    OS.memmove(index, indices, 4);
                    treeSelection[length] = index[0];
                    ++length;
                }
                ++i;
            }
            OS.g_list_free(list);
            int[] result = new int[length];
            System.arraycopy(treeSelection, 0, result, 0, length);
            return result;
        }
        return new int[0];
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] path = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return 0;
        }
        if (path[0] == 0) {
            return 0;
        }
        int indices = OS.gtk_tree_path_get_indices(path[0]);
        int[] index = new int[1];
        if (indices != 0) {
            OS.memmove(index, indices, 4);
        }
        OS.gtk_tree_path_free(path[0]);
        return index[0];
    }

    int gtk_changed(int widget) {
        this.sendSelectionEvent(13);
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        switch (OS.GDK_EVENT_TYPE(gdkEvent)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0) != 0) break;
                this.gtk_expose_event(widget, gdkEvent);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    int gtk_button_press_event(int widget, int event) {
        int selection;
        int[] path;
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button == 3 && gdkEvent.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1;
            }
            OS.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_view_set_cursor(this.handle, path[0], 0, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_path_free(path[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return result;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    this.sendSelectionEvent(14);
                }
            }
        }
        return result;
    }

    int gtk_popup_menu(int widget) {
        int result = super.gtk_popup_menu(widget);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1 : result;
    }

    int gtk_row_activated(int tree, int path, int column) {
        this.sendSelectionEvent(14);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] items = this.getItems();
        int i = start;
        while (i < items.length) {
            if (items[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        byte[] buffer = Converter.wcsToMbcs(null, Integer.toString(index), true);
        int path = OS.gtk_tree_path_new_from_string(buffer);
        boolean answer = OS.gtk_tree_selection_path_is_selected(selection, path);
        OS.gtk_tree_path_free(path);
        return answer;
    }

    int paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_remove(this.modelHandle, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = end;
        while (index >= start) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            OS.gtk_list_store_remove(this.modelHandle, iter);
            --index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                OS.gtk_list_store_remove(this.modelHandle, iter);
                last = index;
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        OS.gtk_tree_selection_select_iter(selection, iter);
        if ((this.style & 4) != 0) {
            int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
            OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
            OS.gtk_tree_path_free(path);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int index = start;
        while (index <= end) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
            OS.gtk_tree_selection_select_iter(selection, iter);
            if ((this.style & 4) != 0) {
                int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                OS.gtk_tree_path_free(path);
            }
            ++index;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < count) {
                OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
                OS.gtk_tree_selection_select_iter(selection, iter);
                if ((this.style & 4) != 0) {
                    int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
                    OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                    OS.gtk_tree_path_free(path);
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.g_free(iter);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
    }

    void selectFocusIndex(int index) {
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (index < 0 || index >= count) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_view_set_cursor(this.handle, path, 0, false);
        OS.gtk_tree_selection_select_iter(selection, iter);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base(this.handle, 0, color);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && OS.gtk_tree_model_iter_n_children(this.modelHandle, 0) == 0) {
            this.redraw(false);
        }
        return result;
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
        OS.g_free(iter);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        int selection = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(14);
        }
        int i2 = 0;
        while (i2 < items.length) {
            String string = items[i2];
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            OS.gtk_list_store_append(this.modelHandle, iter);
            OS.gtk_list_store_set(this.modelHandle, iter, 0, buffer, -1);
            ++i2;
        }
        OS.g_free(iter);
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(index);
        this.showSelection();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int count = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        this.selectFocusIndex(start);
        if ((this.style & 2) != 0) {
            this.select(start, end);
        }
        this.showSelection();
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.selectFocusIndex(indices[0]);
        if ((this.style & 2) != 0) {
            this.select(indices);
        }
        this.showSelection();
    }

    public void setSelection(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean first = true;
        int i = 0;
        while (i < length) {
            int index = 0;
            String string = items[i];
            if (string != null) {
                while ((index = this.indexOf(string, index)) != -1) {
                    if ((this.style & 2) != 0) {
                        if (first) {
                            first = false;
                            this.selectFocusIndex(index);
                        } else {
                            this.select(index);
                        }
                    } else {
                        this.selectFocusIndex(index);
                        break;
                    }
                    ++index;
                }
            }
            ++i;
        }
        this.showSelection();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle cellRect = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, path, 0, cellRect);
            int[] tx = new int[1];
            int[] ty = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        }
        OS.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index == -1) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0, index);
        int path = OS.gtk_tree_model_get_path(this.modelHandle, iter);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle visibleRect = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
        GdkRectangle cellRect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, path, 0, cellRect);
        int[] tx = new int[1];
        int[] ty = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_convert_widget_to_bin_window_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        } else {
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
        }
        if (ty[0] < visibleRect.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
        } else {
            int height = Math.min(visibleRect.height, cellRect.height);
            if (ty[0] + height > visibleRect.y + visibleRect.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 1.0f, 0.0f);
                ty[0] = ty[0] + (cellRect.height - visibleRect.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, ty[0]);
            }
        }
        OS.gtk_tree_path_free(path);
        OS.g_free(iter);
    }

    int treeSelectionProc(int model, int path, int iter, int[] selection, int length) {
        int indices;
        if (selection != null && (indices = OS.gtk_tree_path_get_indices(path)) != 0) {
            int[] index = new int[1];
            OS.memmove(index, indices, 4);
            selection[length] = index[0];
        }
        return 0;
    }
}

