/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class FakedTrackingVariable
extends LocalDeclaration {
    private static final int CLOSE_SEEN = 1;
    private static final int PASSED_TO_OUTSIDE = 2;
    private static final int CLOSED_IN_NESTED_METHOD = 4;
    private static final int REPORTED = 8;
    private int globalClosingState = 0;
    MethodScope methodScope;
    public LocalVariableBinding originalBinding;
    HashMap recordedLocations;

    public FakedTrackingVariable(LocalVariableBinding original, Statement location) {
        super(original.name, location.sourceStart, location.sourceEnd);
        this.type = new SingleTypeReference(TypeConstants.OBJECT, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
        this.methodScope = original.declaringScope.methodScope();
        this.originalBinding = original;
        this.resolve(original.declaringScope);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    public void resolve(BlockScope scope) {
        this.binding = new LocalVariableBinding(this.name, (TypeBinding)scope.getJavaLangObject(), 0, false);
        this.binding.setConstant(Constant.NotAConstant);
        this.binding.useFlag = 1;
        this.binding.id = scope.registerTrackingVariable(this);
    }

    public static FakedTrackingVariable getCloseTrackingVariable(Expression expression) {
        if (expression instanceof SingleNameReference) {
            SingleNameReference name = (SingleNameReference)expression;
            if (name.binding instanceof LocalVariableBinding) {
                LocalVariableBinding local = (LocalVariableBinding)name.binding;
                if (local.closeTracker != null) {
                    return local.closeTracker;
                }
                if (local.isParameter() || !FakedTrackingVariable.isAutoCloseable(expression.resolvedType)) {
                    return null;
                }
                LocalDeclaration location = local.declaration;
                local.closeTracker = new FakedTrackingVariable(local, location);
                return local.closeTracker;
            }
        }
        return null;
    }

    public static LocalVariableBinding getTrackerForCloseCall(ASTNode invocationSite) {
        if (invocationSite instanceof MessageSend) {
            FakedTrackingVariable trackingVariable;
            Binding receiverBinding;
            MessageSend send = (MessageSend)invocationSite;
            if (CharOperation.equals(TypeConstants.CLOSE, send.selector) && send.receiver instanceof SingleNameReference && (receiverBinding = ((SingleNameReference)send.receiver).binding) instanceof LocalVariableBinding && (trackingVariable = ((LocalVariableBinding)receiverBinding).closeTracker) != null) {
                return trackingVariable.binding;
            }
        }
        return null;
    }

    public static void handleResourceAssignment(FlowInfo flowInfo, Statement location, Expression rhs, LocalVariableBinding local, LocalVariableBinding previousTrackerBinding) {
        if (FakedTrackingVariable.isAutoCloseable(rhs.resolvedType)) {
            FakedTrackingVariable rhsTrackVar = FakedTrackingVariable.getCloseTrackingVariable(rhs);
            if (rhsTrackVar != null) {
                local.closeTracker = rhsTrackVar;
            } else if (previousTrackerBinding != null) {
                flowInfo.markAsDefinitelyNull(previousTrackerBinding);
            } else {
                local.closeTracker = new FakedTrackingVariable(local, location);
                flowInfo.markAsDefinitelyNull(local.closeTracker.binding);
            }
        }
    }

    public static boolean isAutoCloseable(TypeBinding typeBinding) {
        return typeBinding instanceof ReferenceBinding && ((ReferenceBinding)typeBinding).hasTypeBit(3);
    }

    public void markClose(FlowInfo flowInfo, FlowContext flowContext) {
        flowInfo.markAsDefinitelyNonNull(this.binding);
        this.globalClosingState |= 1;
    }

    public void markClosedInNestedMethod() {
        this.globalClosingState |= 4;
    }

    public static FlowInfo markPassedToOutside(BlockScope scope, Expression expression, FlowInfo flowInfo) {
        FakedTrackingVariable trackVar = FakedTrackingVariable.getCloseTrackingVariable(expression);
        if (trackVar != null) {
            trackVar.globalClosingState |= 2;
            if (scope.methodScope() != trackVar.methodScope) {
                trackVar.globalClosingState |= 4;
            }
            FlowInfo infoResourceIsClosed = flowInfo.copy();
            infoResourceIsClosed.markAsDefinitelyNonNull(trackVar.binding);
            return FlowInfo.conditional(flowInfo, infoResourceIsClosed);
        }
        return flowInfo;
    }

    public void recordErrorLocation(ASTNode location, int nullStatus) {
        if (this.recordedLocations == null) {
            this.recordedLocations = new HashMap();
        }
        this.recordedLocations.put(location, new Integer(nullStatus));
    }

    public boolean reportRecordedErrors(Scope scope) {
        if (this.globalClosingState == 0) {
            this.reportError(scope.problemReporter(), null, 2);
            return true;
        }
        boolean hasReported = false;
        if (this.recordedLocations != null) {
            Iterator locations = this.recordedLocations.entrySet().iterator();
            while (locations.hasNext()) {
                Map.Entry entry = locations.next();
                this.reportError(scope.problemReporter(), (ASTNode)entry.getKey(), (Integer)entry.getValue());
                hasReported = true;
            }
        }
        return hasReported;
    }

    public void reportError(ProblemReporter problemReporter, ASTNode location, int nullStatus) {
        if (nullStatus == 2) {
            if ((this.globalClosingState & 4) != 0) {
                problemReporter.potentiallyUnclosedCloseable(this, location);
            } else {
                problemReporter.unclosedCloseable(this, location);
            }
        } else if (nullStatus == 16) {
            problemReporter.potentiallyUnclosedCloseable(this, location);
        }
    }

    public void reportExplicitClosing(ProblemReporter problemReporter) {
        if ((this.globalClosingState & 8) == 0) {
            this.globalClosingState |= 8;
            problemReporter.explicitlyClosedAutoCloseable(this);
        }
    }
}

