/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.sapphire.modeling.ModelStore;

public class ByteArrayModelStore
extends ModelStore {
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] contents = EMPTY_BYTE_ARRAY;

    public ByteArrayModelStore() {
    }

    public ByteArrayModelStore(byte[] contents) {
        this.setContents(contents);
    }

    public ByteArrayModelStore(InputStream in) throws IOException {
        this.setContents(in);
    }

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    public void setContents(InputStream in) throws IOException {
        byte[] buffer = new byte[16384];
        int bufferUsedLength = 0;
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer, bufferUsedLength, buffer.length - bufferUsedLength)) != -1) {
            if (buffer.length - (bufferUsedLength += bytesRead) >= 1024) continue;
            byte[] newBuffer = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, bufferUsedLength);
            buffer = newBuffer;
        }
        this.contents = new byte[bufferUsedLength];
        System.arraycopy(buffer, 0, this.contents, 0, bufferUsedLength);
    }

    public void open() throws IOException {
    }

    public void save() throws IOException {
    }
}

