/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayModelStore;
import org.eclipse.sapphire.modeling.IFileModelStore;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;

public class FileModelStore
extends ByteArrayModelStore
implements IFileModelStore {
    private final File file;

    public FileModelStore(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void open() throws IOException {
        if (this.file.exists()) {
            FileInputStream in = new FileInputStream(this.file);
            try {
                this.setContents(in);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        } else {
            this.setContents(EMPTY_BYTE_ARRAY);
        }
    }

    public void save() throws IOException {
        if (this.validateEdit()) {
            try {
                FileUtil.mkdirs(this.file.getParentFile());
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                ((OutputStream)out).write(this.getContents());
                out.flush();
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        } else {
            throw new ValidateEditException();
        }
    }

    public boolean validateEdit() {
        if (this.file.exists()) {
            return this.file.canWrite();
        }
        return true;
    }
}

