/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementListController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayeredModelElementListController<T extends IModelElement, B>
extends ModelElementListController<T> {
    protected List<T> refresh(List<T> content, List<B> newBaseContent) {
        int newContentSize = newBaseContent.size();
        if (content.size() == newContentSize) {
            boolean equal = true;
            int i = 0;
            while (i < newContentSize) {
                if (!this.unwrap((IModelElement)content.get(i)).equals(newBaseContent.get(i))) {
                    equal = false;
                    break;
                }
                ++i;
            }
            if (equal) {
                return content;
            }
        }
        ArrayList<IModelElement> newContent = new ArrayList<IModelElement>(newContentSize);
        if (content.size() > 5 && newContentSize > 5) {
            HashMap<B, IModelElement> map = new HashMap<B, IModelElement>();
            for (IModelElement x : content) {
                map.put(this.unwrap(x), x);
            }
            for (Object baseElement : newBaseContent) {
                IModelElement modelElement = (IModelElement)map.get(baseElement);
                if (modelElement == null) {
                    modelElement = this.wrap(baseElement);
                }
                newContent.add(modelElement);
            }
        } else {
            for (B baseElement : newBaseContent) {
                IModelElement modelElement = null;
                for (IModelElement x : content) {
                    B y = this.unwrap(x);
                    if (!baseElement.equals(y)) continue;
                    modelElement = x;
                    break;
                }
                if (modelElement == null) {
                    modelElement = (IModelElement)this.wrap(baseElement);
                }
                newContent.add(modelElement);
            }
        }
        return newContent;
    }

    protected abstract T wrap(B var1);

    protected abstract B unwrap(T var1);
}

