/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelParticle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelParticle
implements IModelParticle {
    protected final IModel model;
    private final IModelParticle parent;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModelParticle(IModelParticle parent) {
        this.parent = parent;
        if (this.parent == null) {
            if (!(this instanceof IModel)) throw new IllegalArgumentException();
            this.model = (IModel)((Object)this);
            return;
        } else {
            this.model = this.parent.getModel();
        }
    }

    @Override
    public final IModel getModel() {
        return this.model;
    }

    @Override
    public IModelParticle getParent() {
        return this.parent;
    }

    @Override
    public final <T> T findNearestParticle(Class<T> particleType) {
        if (particleType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.findNearestParticle(particleType);
        }
        return null;
    }
}

