/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelStore {
    private static final Locale ROOT_LOCALE = new Locale("");
    private Map<String, String> defaultResourcesReverseLookup = null;
    private Map<Locale, Map<String, String>> localizedResources = null;

    public abstract void open() throws IOException;

    public abstract void save() throws IOException;

    public boolean validateEdit() {
        return true;
    }

    public boolean isOutOfDate() {
        return true;
    }

    public String getLocalizedText(String text, Locale locale) {
        Map<String, String> resourcesForLocale;
        String localizedText;
        String key;
        if (this.defaultResourcesReverseLookup == null) {
            Map<String, String> defaultResources = this.loadLocalizedResources(ROOT_LOCALE);
            if (defaultResources == null) {
                return text;
            }
            this.defaultResourcesReverseLookup = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : defaultResources.entrySet()) {
                this.defaultResourcesReverseLookup.put(entry.getValue(), entry.getKey());
            }
            this.localizedResources = new HashMap<Locale, Map<String, String>>();
        }
        if ((key = this.defaultResourcesReverseLookup.get(text)) != null && (localizedText = (resourcesForLocale = this.getLocalizedResources(locale)).get(key)) != null) {
            return localizedText;
        }
        return text;
    }

    protected Map<String, String> loadLocalizedResources(Locale locale) {
        return null;
    }

    private Map<String, String> getLocalizedResources(Locale locale) {
        Map<String, String> localizedResources = this.localizedResources.get(locale);
        if (localizedResources == null) {
            localizedResources = this.loadLocalizedResources(locale);
            if (localizedResources == null) {
                localizedResources = locale.getVariant().length() > 0 ? this.getLocalizedResources(new Locale(locale.getLanguage(), locale.getCountry())) : (locale.getCountry().length() > 0 ? this.getLocalizedResources(new Locale(locale.getLanguage())) : Collections.emptyMap());
            }
            this.localizedResources.put(locale, localizedResources);
        }
        return localizedResources;
    }
}

