/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.ReferenceResolverImpl;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferenceValue<T>
extends Value<String> {
    private final ReferenceResolverImpl<T> resolver;

    public ReferenceValue(IModelElement parent, ValueProperty property, String value) {
        super(parent, property, value);
        Reference referenceAnnotation = property.getAnnotation(Reference.class);
        if (referenceAnnotation != null) {
            Class<ReferenceResolverImpl<?>> referenceResolverClass = referenceAnnotation.resolver();
            try {
                this.resolver = referenceResolverClass.newInstance();
                this.resolver.init(this.getParent(), property, referenceAnnotation.params());
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public T resolve() {
        String ref = this.getText();
        T result = null;
        if (ref != null) {
            try {
                result = this.resolver.resolve(ref);
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
        return result;
    }
}

