/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelStore;

public final class SharedModelsCache {
    private static final Map<Key, SoftReference<IModel>> cache = new HashMap<Key, SoftReference<IModel>>();

    public static synchronized IModel retrieve(ModelStore modelStore, ModelElementType modelType) {
        Key key = new Key(modelStore, modelType);
        SoftReference<IModel> cachedModelRef = cache.get(key);
        if (cachedModelRef != null) {
            IModel model = cachedModelRef.get();
            if (model != null && !model.getModelStore().isOutOfDate()) {
                return model;
            }
            cache.remove(key);
        }
        return null;
    }

    public static synchronized void store(IModel model) {
        Key key = new Key(model.getModelStore(), model.getModelElementType());
        cache.put(key, new SoftReference<IModel>(model));
    }

    private static final class Key {
        private final ModelStore modelStore;
        private final ModelElementType modelType;

        public Key(ModelStore modelStore, ModelElementType modelType) {
            this.modelStore = modelStore;
            this.modelType = modelType;
        }

        public int hashCode() {
            return this.modelStore.hashCode() ^ this.modelType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.modelStore.equals(key.modelStore) && this.modelType.equals(key.modelType);
            }
            return false;
        }
    }
}

