/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.DoubleValueKeyword;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.FloatValueKeyword;
import org.eclipse.sapphire.modeling.IntegerValueKeyword;
import org.eclipse.sapphire.modeling.LongValueKeyword;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.BasePathsProvider;
import org.eclipse.sapphire.modeling.annotations.EclipseWorkspacePath;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesFromModel;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProvider;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.java.JavaPackageName;
import org.eclipse.sapphire.modeling.java.JavaTypeName;
import org.eclipse.sapphire.modeling.java.internal.JavaTypeNameValidator;
import org.eclipse.sapphire.modeling.java.internal.QualifiedJavaIdentifierValueValidator;
import org.eclipse.sapphire.modeling.validators.AbsolutePathValueValidator;
import org.eclipse.sapphire.modeling.validators.BasicValueValidator;
import org.eclipse.sapphire.modeling.validators.EclipseWorkspacePathValueValidator;
import org.eclipse.sapphire.modeling.validators.NumericRangeValidator;
import org.eclipse.sapphire.modeling.validators.PossibleValuesValidator;
import org.eclipse.sapphire.modeling.validators.ReferenceValueValidator;
import org.eclipse.sapphire.modeling.validators.RelativePathValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueProperty
extends ModelProperty {
    private static final Set<ValueKeyword> NO_KEYWORDS = Collections.emptySet();
    private static final Set<ValueKeyword> INTEGER_KEYWORDS;
    private static final Set<ValueKeyword> LONG_KEYWORDS;
    private static final Set<ValueKeyword> FLOAT_KEYWORDS;
    private static final Set<ValueKeyword> DOUBLE_KEYWORDS;
    private final Method setterMethodGeneric;
    private final Method setterMethodTyped;
    private final Set<ValueKeyword> keywords;

    static {
        HashSet<ValueKeyword> keywords = new HashSet<ValueKeyword>();
        keywords.add(new IntegerValueKeyword("max-int", String.valueOf(Integer.MAX_VALUE)));
        keywords.add(new IntegerValueKeyword("min-int", String.valueOf(Integer.MIN_VALUE)));
        INTEGER_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new LongValueKeyword("max-long", String.valueOf(Long.MAX_VALUE)));
        keywords.add(new LongValueKeyword("min-long", String.valueOf(Long.MIN_VALUE)));
        LONG_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new FloatValueKeyword("max-float", String.valueOf(Float.MAX_VALUE)));
        keywords.add(new FloatValueKeyword("min-float", String.valueOf(Float.MIN_VALUE)));
        FLOAT_KEYWORDS = Collections.unmodifiableSet(keywords);
        keywords = new HashSet();
        keywords.add(new DoubleValueKeyword("max-double", String.valueOf(Double.MAX_VALUE)));
        keywords.add(new DoubleValueKeyword("min-double", String.valueOf(Double.MIN_VALUE)));
        DOUBLE_KEYWORDS = Collections.unmodifiableSet(keywords);
    }

    public ValueProperty(ModelElementType type, String propertyName) {
        this(type, propertyName, null);
    }

    public ValueProperty(ModelElementType type, ValueProperty baseProperty) {
        this(type, baseProperty.getName(), baseProperty);
    }

    private ValueProperty(ModelElementType type, String propertyName, ValueProperty baseProperty) {
        super(type, propertyName, baseProperty);
        if (this.hasAnnotation(ReadOnly.class)) {
            this.setterMethodGeneric = null;
            this.setterMethodTyped = null;
        } else {
            String propLowerCase = propertyName.toLowerCase();
            String setterMethodName = "set" + propLowerCase;
            Method setterGeneric = null;
            Method setterTyped = null;
            Method[] methodArray = type.getModelElementClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String methodName = method.getName().toLowerCase();
                if (methodName.equals(setterMethodName)) {
                    if (Arrays.equals(method.getParameterTypes(), new Class[]{String.class})) {
                        setterGeneric = method;
                    } else {
                        setterTyped = method;
                    }
                }
                ++n2;
            }
            if (setterGeneric == null) {
                throw new IllegalStateException(propertyName);
            }
            this.setterMethodGeneric = setterGeneric;
            this.setterMethodTyped = setterTyped;
        }
        Class<?> propType = this.getTypeClass();
        this.keywords = propType == Integer.class ? INTEGER_KEYWORDS : (propType == Long.class ? LONG_KEYWORDS : (propType == Float.class ? FLOAT_KEYWORDS : (propType == Double.class ? DOUBLE_KEYWORDS : NO_KEYWORDS)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invokeSetterMethod(Object model, Object value) {
        if (this.setterMethodGeneric == null) {
            String msg = NLS.bind((String)Resources.noSetterMethod, (Object)this.getModelElementType().getModelElementClass().getName(), (Object)this.getName());
            throw new RuntimeException(msg);
        }
        if (value == null || value instanceof String) {
            try {
                this.setterMethodGeneric.invoke(model, value);
                return;
            }
            catch (Exception e) {
                throw this.convertReflectiveInvocationException(e);
            }
        }
        if (this.setterMethodTyped == null) {
            String msg = NLS.bind((String)Resources.noTypedSetterMethod, (Object)this.getModelElementType().getModelElementClass().getName(), (Object)this.getName());
            throw new RuntimeException(msg);
        }
        try {
            this.setterMethodTyped.invoke(model, value);
            return;
        }
        catch (Exception e) {
            throw this.convertReflectiveInvocationException(e);
        }
    }

    @Override
    protected List<ModelPropertyValidator<? extends Object>> createValidators() {
        NumericRange rangeConstraintAnnotation;
        Class<?> type;
        List<ModelPropertyValidator<? extends Object>> validators = super.createValidators();
        if (this.hasAnnotation(NonNullValue.class)) {
            final String labelText = this.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
            ModelPropertyValidator nullValueValidator = new ModelPropertyValidator<Value<?>>(){

                @Override
                public IStatus validate(Value<?> value) {
                    if (value.getText() == null) {
                        String message = Resources.bind((String)Resources.nullValueValidationMessage, (Object)labelText);
                        return new Status(4, "org.eclipse.sapphire.modeling", message);
                    }
                    return Status.OK_STATUS;
                }
            };
            validators.add(nullValueValidator);
        }
        if (this.hasAnnotation(Reference.class)) {
            validators.add(new ReferenceValueValidator());
        }
        if (Boolean.class.isAssignableFrom(type = this.getTypeClass())) {
            validators.add(new BasicValueValidator("boolean"));
        } else if (Integer.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("integer"));
        } else if (Long.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("long integer"));
        } else if (Float.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("single precision floating point number"));
        } else if (Double.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("double precision floating point number"));
        } else if (BigInteger.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("integer"));
        } else if (BigDecimal.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("decimal"));
        } else if (Enum.class.isAssignableFrom(type)) {
            EnumValueType enumValueType = null;
            Field[] fieldArray = type.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().equals("TYPE")) {
                    try {
                        Object fieldValue = field.get(null);
                        if (fieldValue instanceof EnumValueType) {
                            enumValueType = (EnumValueType)fieldValue;
                            break;
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++n2;
            }
            if (enumValueType == null) {
                enumValueType = new EnumValueType(type);
            }
            String enumTypeLabel = enumValueType.getLabel(true, CapitalizationType.NO_CAPS, false);
            validators.add(new BasicValueValidator(enumTypeLabel));
        } else if (JavaPackageName.class.isAssignableFrom(type)) {
            validators.add(new QualifiedJavaIdentifierValueValidator());
        } else if (JavaTypeName.class.isAssignableFrom(type)) {
            validators.add(new QualifiedJavaIdentifierValueValidator());
            validators.add(new JavaTypeNameValidator(this));
        } else if (IPath.class.isAssignableFrom(type)) {
            if (this.hasAnnotation(AbsolutePath.class)) {
                validators.add(new AbsolutePathValueValidator(this));
            } else if (this.hasAnnotation(BasePathsProvider.class)) {
                validators.add(new RelativePathValueValidator(this));
            } else if (this.hasAnnotation(EclipseWorkspacePath.class)) {
                validators.add(new EclipseWorkspacePathValueValidator(this));
            }
        } else if (URL.class.isAssignableFrom(type)) {
            validators.add(new BasicValueValidator("URL"));
        }
        if (PossibleValuesValidator.isNecessary(this)) {
            validators.add(new PossibleValuesValidator());
        }
        if ((rangeConstraintAnnotation = this.getAnnotation(NumericRange.class)) != null) {
            String minStr = rangeConstraintAnnotation.min();
            String maxStr = rangeConstraintAnnotation.max();
            if (minStr != null || maxStr != null) {
                try {
                    Number max;
                    if (Integer.class.isAssignableFrom(type)) {
                        Integer min = minStr.length() > 0 ? Integer.valueOf(minStr) : null;
                        max = maxStr.length() > 0 ? Integer.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>(min, (Integer)max));
                    } else if (Long.class.isAssignableFrom(type)) {
                        Long min = minStr.length() > 0 ? Long.valueOf(minStr) : null;
                        max = maxStr.length() > 0 ? Long.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>((Integer)((Object)min), (Integer)max));
                    } else if (Float.class.isAssignableFrom(type)) {
                        Float min = minStr.length() > 0 ? Float.valueOf(minStr) : null;
                        max = maxStr.length() > 0 ? Float.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>((Integer)((Object)min), (Integer)max));
                    } else if (Double.class.isAssignableFrom(type)) {
                        Double min = minStr.length() > 0 ? Double.valueOf(minStr) : null;
                        max = maxStr.length() > 0 ? Double.valueOf(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>((Integer)((Object)min), (Integer)max));
                    } else if (BigInteger.class.isAssignableFrom(type)) {
                        BigInteger min = minStr.length() > 0 ? new BigInteger(minStr) : null;
                        max = maxStr.length() > 0 ? new BigInteger(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>((Integer)((Object)min), (Integer)max));
                    } else if (BigDecimal.class.isAssignableFrom(type)) {
                        BigDecimal min = minStr.length() > 0 ? new BigDecimal(minStr) : null;
                        max = maxStr.length() > 0 ? new BigDecimal(maxStr) : null;
                        validators.add(new NumericRangeValidator<Integer>((Integer)((Object)min), (Integer)max));
                    }
                }
                catch (NumberFormatException e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
        }
        return validators;
    }

    public Set<ValueKeyword> getKeywords() {
        return this.keywords;
    }

    public ValueKeyword getKeyword(String keyword) {
        for (ValueKeyword kwd : this.keywords) {
            if (!kwd.getKeyword().equals(keyword)) continue;
            return kwd;
        }
        return null;
    }

    public String decodeKeywords(String value) {
        String result = value;
        if (value != null) {
            for (ValueKeyword keyword : this.keywords) {
                result = keyword.decode(value);
                if (result != value) break;
            }
        }
        return result;
    }

    public String encodeKeywords(String value) {
        String result = value;
        if (value != null) {
            for (ValueKeyword keyword : this.keywords) {
                result = keyword.encode(value);
                if (result != value) break;
            }
        }
        return result;
    }

    public boolean hasPossibleValuesProvider() {
        return this.hasAnnotation(PossibleValuesProvider.class) || this.hasAnnotation(PossibleValues.class) || this.hasAnnotation(PossibleValuesFromModel.class);
    }

    private static final class Resources
    extends NLS {
        public static String nullValueValidationMessage;
        public static String noSetterMethod;
        public static String noTypedSetterMethod;

        static {
            Resources.initializeMessages((String)ValueProperty.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

