/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.annotations;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesChangedEvent;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderListener;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PossibleValuesProviderImpl {
    private IModelElement element;
    private ValueProperty property;
    private String invalidValueMessageTemplate;
    private int invalidValueSeverity;
    private boolean isCaseSensitive;
    private final Set<PossibleValuesProviderListener> listeners = new CopyOnWriteArraySet<PossibleValuesProviderListener>();

    public void init(IModelElement element, ValueProperty property, String invalidValueMessageTemplate, int invalidValueSeverity, boolean isCaseSensitive, String[] params) {
        this.element = element;
        this.property = property;
        this.invalidValueMessageTemplate = invalidValueMessageTemplate;
        this.invalidValueSeverity = invalidValueSeverity;
        this.isCaseSensitive = isCaseSensitive;
    }

    public final IModelElement getModelElement() {
        return this.element;
    }

    public final ValueProperty getProperty() {
        return this.property;
    }

    public final SortedSet<String> getPossibleValues() {
        TreeSet<String> values = new TreeSet<String>();
        this.fillPossibleValues(values);
        return values;
    }

    protected abstract void fillPossibleValues(SortedSet<String> var1);

    public String getInvalidValueMessage(String invalidValue) {
        if (this.invalidValueMessageTemplate == null) {
            throw new IllegalStateException();
        }
        String template = this.invalidValueMessageTemplate;
        return NLS.bind((String)template, (Object)invalidValue);
    }

    public int getInvalidValueSeverity(String invalidValue) {
        return this.invalidValueSeverity;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public final void addListener(PossibleValuesProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public final void removeListener(PossibleValuesProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(PossibleValuesChangedEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        for (PossibleValuesProviderListener listener : this.listeners) {
            try {
                listener.handlePossibleValuesChangedEvent(event);
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
    }
}

