/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.EnablerImpl;
import org.eclipse.sapphire.modeling.scripting.Script;
import org.eclipse.sapphire.modeling.scripting.ScriptsManager;
import org.eclipse.sapphire.modeling.scripting.VariableResolver;

public final class ScriptBasedEnabler
extends EnablerImpl {
    private Script script;
    private VariableResolver variableResolver;

    public void init(final IModelElement element, ModelProperty property, String[] params) {
        super.init(element, property, params);
        if (params.length != 1) {
            throw new IllegalArgumentException();
        }
        this.script = ScriptsManager.loadScript(params[0]);
        this.variableResolver = new VariableResolver(){

            public Object resolve(String name) {
                ModelProperty property = element.getModelElementType().getProperty(name);
                if (property != null && property instanceof ValueProperty) {
                    ValueProperty prop = (ValueProperty)property;
                    String val = ((Value)prop.invokeGetterMethod(element)).getText();
                    return val != null ? val : "";
                }
                return name;
            }
        };
    }

    public boolean isEnabled() {
        Object result = this.script.execute(this.variableResolver);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }
}

