/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.java.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.java.JavaTypeConstraints;
import org.eclipse.sapphire.modeling.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.java.JavaTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTypeNameValidator
extends ModelPropertyValidator<Value<JavaTypeName>> {
    private final ValueProperty property;
    private final boolean typeMustExist;
    private final boolean isClassOk;
    private final boolean isAbstractClassOk;
    private final boolean isInterfaceOk;
    private final boolean isAnnotationOk;
    private final boolean isEnumOk;
    private final String[] validBaseTypes;

    public JavaTypeNameValidator(ValueProperty property) {
        this.property = property;
        this.typeMustExist = this.property.getAnnotation(MustExist.class) != null;
        JavaTypeConstraints javaTypeConstraintsAnnotation = this.property.getAnnotation(JavaTypeConstraints.class);
        if (javaTypeConstraintsAnnotation != null) {
            this.validBaseTypes = javaTypeConstraintsAnnotation.type();
            boolean c = false;
            boolean d = false;
            boolean i = false;
            boolean a = false;
            boolean e = false;
            JavaTypeKind[] javaTypeKindArray = javaTypeConstraintsAnnotation.kind();
            int n = javaTypeKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                JavaTypeKind kind = javaTypeKindArray[n2];
                switch (kind) {
                    case CLASS: {
                        c = true;
                        break;
                    }
                    case ABSTRACT_CLASS: {
                        d = true;
                        break;
                    }
                    case INTERFACE: {
                        i = true;
                        break;
                    }
                    case ANNOTATION: {
                        a = true;
                        break;
                    }
                    case ENUM: {
                        e = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ++n2;
            }
            this.isClassOk = c;
            this.isAbstractClassOk = d;
            this.isInterfaceOk = i;
            this.isAnnotationOk = a;
            this.isEnumOk = e;
        } else {
            this.validBaseTypes = new String[0];
            this.isClassOk = true;
            this.isAbstractClassOk = true;
            this.isInterfaceOk = true;
            this.isAnnotationOk = true;
            this.isEnumOk = true;
        }
    }

    @Override
    public IStatus validate(Value<JavaTypeName> value) {
        String val = value.getText(false);
        if (val != null) {
            IProject project = (IProject)Platform.getAdapterManager().loadAdapter((Object)value.getModel(), IProject.class.getName());
            if (project == null) {
                project = value.getModel().getEclipseProject();
            }
            if (project != null) {
                try {
                    IType type = JavaTypeNameValidator.getType(val, project);
                    if (type == null || !type.exists()) {
                        if (this.typeMustExist) {
                            String msg = Resources.bind((String)Resources.typeNotFound, (Object)val);
                            return this.createErrorStatus(msg);
                        }
                        return Status.OK_STATUS;
                    }
                    if (type.isClass()) {
                        IStatus st;
                        boolean isAbstract = Flags.isAbstract((int)type.getFlags());
                        if (isAbstract) {
                            if (!this.isAbstractClassOk) {
                                String label = this.property.getLabel(false, CapitalizationType.NO_CAPS, false);
                                String msg = Resources.bind((String)Resources.abstractClassNotAllowed, (Object)val, (Object)label);
                                return this.createErrorStatus(msg);
                            }
                        } else if (!this.isClassOk) {
                            String label = this.property.getLabel(false, CapitalizationType.NO_CAPS, false);
                            String msg = Resources.bind((String)Resources.classNotAllowed, (Object)val, (Object)label);
                            return this.createErrorStatus(msg);
                        }
                        if ((st = this.validateRequiredType(type, val)) != null) {
                            return st;
                        }
                    } else if (type.isAnnotation()) {
                        if (!this.isAnnotationOk) {
                            String label = this.property.getLabel(false, CapitalizationType.NO_CAPS, false);
                            String msg = Resources.bind((String)Resources.annotationNotAllowed, (Object)val, (Object)label);
                            return this.createErrorStatus(msg);
                        }
                    } else if (type.isInterface()) {
                        if (!this.isInterfaceOk) {
                            String label = this.property.getLabel(false, CapitalizationType.NO_CAPS, false);
                            String msg = Resources.bind((String)Resources.interfaceNotAllowed, (Object)val, (Object)label);
                            return this.createErrorStatus(msg);
                        }
                        IStatus st = this.validateRequiredType(type, val);
                        if (st != null) {
                            return st;
                        }
                    } else if (type.isEnum() && !this.isEnumOk) {
                        String label = this.property.getLabel(false, CapitalizationType.NO_CAPS, false);
                        String msg = Resources.bind((String)Resources.enumNotAllowed, (Object)val, (Object)label);
                        return this.createErrorStatus(msg);
                    }
                }
                catch (CoreException e) {
                    SapphireModelingFrameworkPlugin.log((Exception)((Object)e));
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validateRequiredType(IType type, String typeName) throws JavaModelException {
        if (this.validBaseTypes.length > 0) {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            String[] stringArray = this.validBaseTypes;
            int n = this.validBaseTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String baseType = stringArray[n2];
                if (!type.getFullyQualifiedName().equals(baseType)) {
                    boolean hasSuperType = false;
                    IType[] iTypeArray = typeHierarchy.getAllSupertypes(type);
                    int n3 = iTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType t = iTypeArray[n4];
                        if (t.getFullyQualifiedName().equals(baseType)) {
                            hasSuperType = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!hasSuperType) {
                        String template = type.isClass() ? Resources.classDoesNotImplementOrExtend : Resources.interfaceDoesNotExtend;
                        String msg = Resources.bind((String)template, (Object)typeName, (Object)baseType);
                        return this.createErrorStatus(msg);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private static IType getType(String fullyQualifiedType, IProject project) {
        if (fullyQualifiedType.trim().length() == 0 || fullyQualifiedType.startsWith(".") || fullyQualifiedType.endsWith(".")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(fullyQualifiedType);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
        }
        catch (JavaModelException ce) {
            SapphireModelingFrameworkPlugin.log((Exception)((Object)ce));
        }
        return type;
    }

    private static final class Resources
    extends NLS {
        public static String typeNotFound;
        public static String classDoesNotImplementOrExtend;
        public static String interfaceDoesNotExtend;
        public static String abstractClassNotAllowed;
        public static String classNotAllowed;
        public static String interfaceNotAllowed;
        public static String annotationNotAllowed;
        public static String enumNotAllowed;

        static {
            Resources.initializeMessages((String)JavaTypeNameValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

