/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.LayeredModelElementListController;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.XmlElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElementListControllerForXml<T extends IModelElementForXml>
extends LayeredModelElementListController<T, XmlElement> {
    private final Collection<String> xmlElementNames;

    public ModelElementListControllerForXml(Collection<String> xmlElementNames) {
        this.xmlElementNames = xmlElementNames;
    }

    @Override
    public List<T> refresh(List<T> content) {
        XmlElement parent = this.getParentXmlElement(false);
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList<XmlElement> xmlElements = new ArrayList<XmlElement>();
        for (XmlElement element : parent.getChildElements()) {
            String elementName = element.getDomNode().getLocalName();
            if (!this.xmlElementNames.contains(elementName)) continue;
            xmlElements.add(element);
        }
        return this.refresh(content, xmlElements);
    }

    @Override
    public void swap(T a, T b) {
        this.validateEdit();
        a.getXmlElement().swap(b.getXmlElement());
    }

    @Override
    protected XmlElement unwrap(T obj) {
        return obj.getXmlElement();
    }

    protected abstract XmlElement getParentXmlElement(boolean var1);

    protected void validateEdit() {
        this.getModelElement().getModel().validateEdit();
    }
}

