/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import org.eclipse.sapphire.modeling.CorruptedModelStoreException;
import org.eclipse.sapphire.modeling.CorruptedModelStoreExceptionInterceptor;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.Model;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.xml.IModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public abstract class ModelForXml
extends Model
implements IModel,
IModelElementForXml {
    private static final String PI_XML_TARGET = "xml";
    private static final String PI_XML_DATA = "version=\"1.0\" encoding=\"UTF-8\"";
    protected final ModelStoreForXml modelStoreForXml;
    private RootElementController rootElementController;

    public ModelForXml(ModelElementType type, ModelStoreForXml modelStore) {
        super(type, modelStore);
        this.modelStoreForXml = modelStore;
        this.rootElementController = this.createRootElementController();
        this.rootElementController.init(modelStore, type);
    }

    protected abstract RootElementController createRootElementController();

    public final boolean isCorrupted() {
        Document document = this.modelStoreForXml.getDocument();
        Element root = document.getDocumentElement();
        if (document.getChildNodes().getLength() == 0) {
            return true;
        }
        if (root == null) {
            return true;
        }
        return !this.rootElementController.checkRootElement(this.modelStoreForXml.getDocument());
    }

    public final XmlElement getXmlElement() {
        return this.getXmlElement(false);
    }

    public final XmlElement getXmlElement(boolean createIfNecessary) {
        Document document = this.modelStoreForXml.getDocument();
        Element root = document.getDocumentElement();
        if (document.getChildNodes().getLength() == 0) {
            if (createIfNecessary) {
                this.fixMalformedDescriptor();
                root = document.getDocumentElement();
            }
        } else {
            boolean isRootValid;
            boolean bl = isRootValid = root == null ? false : this.rootElementController.checkRootElement(this.modelStoreForXml.getDocument());
            if (!isRootValid) {
                root = null;
                if (createIfNecessary) {
                    CorruptedModelStoreExceptionInterceptor interceptor = this.getCorruptedModelStoreExceptionInterceptor();
                    if (interceptor != null && interceptor.shouldAttemptRepair()) {
                        this.fixMalformedDescriptor();
                        root = document.getDocumentElement();
                    } else {
                        throw new CorruptedModelStoreException();
                    }
                }
            }
        }
        if (root == null) {
            return null;
        }
        this.modelStoreForXml.registerModelElement(root, this);
        return new XmlElement(null, root, this.modelStoreForXml);
    }

    public XmlNode getXmlNode(ModelProperty property) {
        return this.getXmlNode(property, false);
    }

    public XmlNode getXmlNode(ModelProperty property, boolean createIfNecessary) {
        return null;
    }

    private final void fixMalformedDescriptor() {
        Document document = this.modelStoreForXml.getDocument();
        NodeList topLevelNodes = document.getChildNodes();
        Node[] nodes = new Node[topLevelNodes.getLength()];
        int i = 0;
        int n = nodes.length;
        while (i < n) {
            nodes[i] = topLevelNodes.item(i);
            ++i;
        }
        Node[] nodeArray = nodes;
        int n2 = nodes.length;
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeArray[n3];
            document.removeChild(node);
            ++n3;
        }
        if (this.modelStoreForXml.isXmlDeclarationNeeded()) {
            this.addXmlProcessingInstruction(document);
        }
        this.rootElementController.createRootElement(this.modelStoreForXml.getDocument());
    }

    private void addXmlProcessingInstruction(Document document) {
        NodeList nodes = document.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            ProcessingInstruction pi;
            Node node = nodes.item(i);
            if (node.getNodeType() == 7 && (pi = (ProcessingInstruction)node).getTarget().equals(PI_XML_TARGET)) {
                pi.setData(PI_XML_DATA);
                return;
            }
            ++i;
        }
        ProcessingInstruction pi = document.createProcessingInstruction(PI_XML_TARGET, PI_XML_DATA);
        document.insertBefore(pi, document.getFirstChild());
    }
}

