/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.util.Map;
import org.eclipse.sapphire.modeling.util.internal.MiscUtil;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StandardRootElementController
extends RootElementController {
    private final RootElementInfo info;

    public StandardRootElementController() {
        this.info = null;
    }

    public StandardRootElementController(String namespace, String schemaLocation, String defaultPrefix, String elementName) {
        this.info = new RootElementInfo(namespace, schemaLocation, defaultPrefix, elementName);
    }

    public StandardRootElementController(String elementName) {
        this(null, null, null, elementName);
    }

    protected RootElementInfo getRootElementInfo() {
        return this.info;
    }

    public void createRootElement(Document document) {
        this.createRootElement(document, this.getRootElementInfo());
    }

    protected void createRootElement(Document document, RootElementInfo rinfo) {
        Element root;
        if (rinfo.namespace == null) {
            root = document.createElementNS(null, rinfo.elementName);
        } else {
            XmlDocumentSchema xmlDocumentSchema;
            if (rinfo.defaultPrefix == null) {
                root = document.createElementNS(rinfo.namespace, rinfo.elementName);
                root.setAttribute("xmlns", rinfo.namespace);
            } else {
                root = document.createElementNS(rinfo.namespace, String.valueOf(rinfo.defaultPrefix) + ":" + rinfo.elementName);
                root.setAttribute("xmlns:" + rinfo.defaultPrefix, rinfo.namespace);
            }
            root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (rinfo.schemaLocation != null && (xmlDocumentSchema = XmlDocumentSchemasCache.getSchema(rinfo.schemaLocation)) != null) {
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<String, String> entry : xmlDocumentSchema.getSchemaLocations().entrySet()) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(entry.getKey());
                    buf.append(' ');
                    buf.append(entry.getValue());
                }
                if (buf.length() > 0) {
                    root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", buf.toString());
                }
            }
        }
        document.appendChild(root);
    }

    public boolean checkRootElement(Document document) {
        return this.checkRootElement(document, this.getRootElementInfo());
    }

    protected boolean checkRootElement(Document document, RootElementInfo rinfo) {
        Element root = document.getDocumentElement();
        String localName = root.getLocalName();
        String namespace = root.getNamespaceURI();
        return MiscUtil.equal(localName, rinfo.elementName) && MiscUtil.equal(namespace, rinfo.namespace);
    }

    protected static final class RootElementInfo {
        public final String namespace;
        public final String schemaLocation;
        public final String defaultPrefix;
        public final String elementName;

        public RootElementInfo(String namespace, String schemaLocation, String defaultPrefix, String elementName) {
            this.namespace = namespace;
            this.schemaLocation = schemaLocation;
            this.defaultPrefix = defaultPrefix;
            this.elementName = elementName;
        }
    }
}

