/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.XmlComment;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlNode {
    protected static final String EMPTY_STRING = "";
    private final Node domNode;
    private final ModelStoreForXml modelStoreForXml;

    public XmlNode(Node domNode, ModelStoreForXml modelStoreForXml) {
        if (domNode == null) {
            throw new IllegalArgumentException();
        }
        this.domNode = domNode;
        this.modelStoreForXml = modelStoreForXml;
    }

    public ModelStoreForXml getModelStoreForXml() {
        return this.modelStoreForXml;
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlNode) {
            return this.domNode == ((XmlNode)obj).domNode;
        }
        return false;
    }

    public int hashCode() {
        return this.domNode.hashCode();
    }

    public Node getDomNode() {
        return this.domNode;
    }

    public final String getText() {
        return this.getText(false);
    }

    public final String getText(boolean removeExtraWhitespace) {
        String text = this.getTextInternal().trim();
        if (removeExtraWhitespace) {
            StringBuilder buf = new StringBuilder();
            boolean skipNextWhitespace = true;
            int i = 0;
            int n = text.length();
            while (i < n) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) {
                    if (!skipNextWhitespace) {
                        buf.append(' ');
                        skipNextWhitespace = true;
                    }
                } else {
                    buf.append(ch);
                    skipNextWhitespace = false;
                }
                ++i;
            }
            int length = buf.length();
            if (length > 0 && buf.charAt(length - 1) == ' ') {
                buf.deleteCharAt(length - 1);
            }
            text = buf.toString();
        }
        return text;
    }

    protected abstract String getTextInternal();

    public abstract void setText(String var1);

    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            DOMSource source = new DOMSource(this.domNode);
            StreamResult result = new StreamResult(sw);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    public void format() {
        this.removeFormatting();
        int depth = 0;
        if (this.domNode.getParentNode() != null) {
            Node n = this.domNode.getParentNode();
            while (n.getNodeType() == 1) {
                ++depth;
                n = n.getParentNode();
            }
        }
        this.format(depth);
    }

    private void format(int depth) {
        StringBuilder buf = new StringBuilder();
        buf.append('\n');
        int i = 0;
        while (i < depth) {
            buf.append("    ");
            ++i;
        }
        String formatting = buf.toString();
        Document document = this.domNode.getOwnerDocument();
        Node parent = this.domNode.getParentNode();
        if (parent.getNodeType() == 1 || parent.getNodeType() == 9) {
            Text textBeforeOpeningTag = document.createTextNode(formatting);
            parent.insertBefore(textBeforeOpeningTag, this.domNode);
        }
        if (this.domNode.getNodeType() == 1 && this.domNode.getChildNodes().getLength() > 0) {
            Text textBeforeClosingTag = document.createTextNode(formatting);
            this.domNode.appendChild(textBeforeClosingTag);
        }
        NodeList childNodeList = this.domNode.getChildNodes();
        ArrayList<XmlNode> childNodesToFormat = new ArrayList<XmlNode>();
        int i2 = 0;
        int n = childNodeList.getLength();
        while (i2 < n) {
            Node child = childNodeList.item(i2);
            if (child.getNodeType() == 1) {
                childNodesToFormat.add(new XmlElement((XmlElement)this, (Element)child, this.modelStoreForXml));
            } else if (child.getNodeType() == 8) {
                childNodesToFormat.add(new XmlComment(child, this.getModelStoreForXml()));
            }
            ++i2;
        }
        int depthPlusOne = depth + 1;
        for (XmlNode childNode : childNodesToFormat) {
            childNode.format(depthPlusOne);
        }
    }

    public void removeFormatting() {
        Node child;
        NodeList nodes = this.domNode.getChildNodes();
        ArrayList<Node> textNodesToRemove = new ArrayList<Node>();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            child = nodes.item(i);
            if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                textNodesToRemove.add(child);
            }
            ++i;
        }
        for (Node n2 : textNodesToRemove) {
            this.domNode.removeChild(n2);
        }
        i = 0;
        n = nodes.getLength();
        while (i < n) {
            child = nodes.item(i);
            if (child.getNodeType() == 1) {
                new XmlElement((XmlElement)this, (Element)child, this.modelStoreForXml).removeFormatting();
            }
            ++i;
        }
        Node prevSibling = this.domNode.getPreviousSibling();
        if (prevSibling != null && prevSibling.getNodeType() == 3 && prevSibling.getNodeValue().trim().length() == 0) {
            this.domNode.getParentNode().removeChild(prevSibling);
        }
    }

    public abstract void remove();
}

