/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.integrated.internal;

import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.calendar.integrated.IEvent;
import org.eclipse.sapphire.samples.calendar.integrated.IEventAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventStub
extends ModelElement
implements IEvent {
    private ModelElementList<IEventAttachment> attachments = null;
    private ModelElementList<IAttendee> attendees = null;
    private Value<String> endTime = null;
    private Value<String> location = null;
    private Value<String> notes = null;
    private Value<String> startTime = null;
    private Value<String> subject = null;

    public EventStub(IModelParticle parent, ModelProperty parentProperty) {
        super(TYPE, parent, parentProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IEventAttachment> getAttachments() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.attachments == null) {
                this.refresh((ModelProperty)PROP_ATTACHMENTS, true);
            }
            return this.attachments;
        }
    }

    protected abstract ModelElementList<IEventAttachment> initAttachments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAttendee> getAttendees() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.attendees == null) {
                this.refresh((ModelProperty)PROP_ATTENDEES, true);
            }
            return this.attendees;
        }
    }

    protected abstract ModelElementList<IAttendee> initAttendees();

    protected abstract String readEndTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getEndTime() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.endTime == null) {
                this.refresh((ModelProperty)PROP_END_TIME, true);
            }
            return this.endTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndTime(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_END_TIME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_END_TIME, true);
            if (!EventStub.equal((String)this.endTime.getText(false), (String)value)) {
                this.validateEdit();
                this.writeEndTime(value);
                this.refresh((ModelProperty)PROP_END_TIME, false);
            }
        }
    }

    protected abstract void writeEndTime(String var1);

    protected abstract String readLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getLocation() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.location == null) {
                this.refresh((ModelProperty)PROP_LOCATION, true);
            }
            return this.location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocation(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LOCATION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LOCATION, true);
            if (!EventStub.equal((String)this.location.getText(false), (String)value)) {
                this.validateEdit();
                this.writeLocation(value);
                this.refresh((ModelProperty)PROP_LOCATION, false);
            }
        }
    }

    protected abstract void writeLocation(String var1);

    protected abstract String readNotes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getNotes() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.notes == null) {
                this.refresh((ModelProperty)PROP_NOTES, true);
            }
            return this.notes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotes(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NOTES.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NOTES, true);
            if (!EventStub.equal((String)this.notes.getText(false), (String)value)) {
                this.validateEdit();
                this.writeNotes(value);
                this.refresh((ModelProperty)PROP_NOTES, false);
            }
        }
    }

    protected abstract void writeNotes(String var1);

    protected abstract String readStartTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStartTime() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.startTime == null) {
                this.refresh((ModelProperty)PROP_START_TIME, true);
            }
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStartTime(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_START_TIME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_START_TIME, true);
            if (!EventStub.equal((String)this.startTime.getText(false), (String)value)) {
                this.validateEdit();
                this.writeStartTime(value);
                this.refresh((ModelProperty)PROP_START_TIME, false);
            }
        }
    }

    protected abstract void writeStartTime(String var1);

    protected abstract String readSubject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getSubject() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.subject == null) {
                this.refresh((ModelProperty)PROP_SUBJECT, true);
            }
            return this.subject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubject(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_SUBJECT.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_SUBJECT, true);
            if (!EventStub.equal((String)this.subject.getText(false), (String)value)) {
                this.validateEdit();
                this.writeSubject(value);
                this.refresh((ModelProperty)PROP_SUBJECT, false);
            }
        }
    }

    protected abstract void writeSubject(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ATTACHMENTS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ATTACHMENTS);
                if (this.attachments == null && force) {
                    this.attachments = this.initAttachments();
                }
                if (this.attachments != null && !(notified = this.attachments.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_ATTACHMENTS);
                }
            } else if (property == PROP_ATTENDEES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ATTENDEES);
                if (this.attendees == null && force) {
                    this.attendees = this.initAttendees();
                }
                if (this.attendees != null && !(notified = this.attendees.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_ATTENDEES);
                }
            } else if (property == PROP_END_TIME) {
                if (this.endTime != null || force) {
                    Value<String> oldValue = this.endTime;
                    String val = this.readEndTime();
                    this.endTime = new Value((IModelElement)this, PROP_END_TIME, PROP_END_TIME.encodeKeywords(val));
                    this.endTime.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_END_TIME);
                    if (oldValue != null) {
                        if (this.endTime.equals(oldValue)) {
                            this.endTime = oldValue;
                        }
                        if (this.endTime != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_END_TIME);
                        }
                    }
                }
            } else if (property == PROP_LOCATION) {
                if (this.location != null || force) {
                    Value<String> oldValue = this.location;
                    String val = this.readLocation();
                    this.location = new Value((IModelElement)this, PROP_LOCATION, PROP_LOCATION.encodeKeywords(val));
                    this.location.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LOCATION);
                    if (oldValue != null) {
                        if (this.location.equals(oldValue)) {
                            this.location = oldValue;
                        }
                        if (this.location != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_LOCATION);
                        }
                    }
                }
            } else if (property == PROP_NOTES) {
                if (this.notes != null || force) {
                    Value<String> oldValue = this.notes;
                    String val = this.readNotes();
                    this.notes = new Value((IModelElement)this, PROP_NOTES, PROP_NOTES.encodeKeywords(val));
                    this.notes.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NOTES);
                    if (oldValue != null) {
                        if (this.notes.equals(oldValue)) {
                            this.notes = oldValue;
                        }
                        if (this.notes != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NOTES);
                        }
                    }
                }
            } else if (property == PROP_START_TIME) {
                if (this.startTime != null || force) {
                    Value<String> oldValue = this.startTime;
                    String val = this.readStartTime();
                    this.startTime = new Value((IModelElement)this, PROP_START_TIME, PROP_START_TIME.encodeKeywords(val));
                    this.startTime.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_START_TIME);
                    if (oldValue != null) {
                        if (this.startTime.equals(oldValue)) {
                            this.startTime = oldValue;
                        }
                        if (this.startTime != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_START_TIME);
                        }
                    }
                }
            } else if (property == PROP_SUBJECT && (this.subject != null || force)) {
                Value<String> oldValue = this.subject;
                String val = this.readSubject();
                this.subject = new Value((IModelElement)this, PROP_SUBJECT, PROP_SUBJECT.encodeKeywords(val));
                this.subject.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_SUBJECT);
                if (oldValue != null) {
                    if (this.subject.equals(oldValue)) {
                        this.subject = oldValue;
                    }
                    if (this.subject != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_SUBJECT);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            this.validateEdit();
            this.doRemove();
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    protected abstract void doRemove();
}

