/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.ListPropertyCustomBinding;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.contacts.IAddress;
import org.eclipse.sapphire.samples.contacts.IAssistant;
import org.eclipse.sapphire.samples.contacts.IConnection;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.IPhoneNumber;
import org.eclipse.sapphire.samples.contacts.IWebSite;
import org.eclipse.sapphire.samples.contacts.internal.Address;
import org.eclipse.sapphire.samples.contacts.internal.Assistant;
import org.eclipse.sapphire.samples.contacts.internal.ConnectionsListController;
import org.eclipse.sapphire.samples.contacts.internal.ContactMethods;
import org.eclipse.sapphire.samples.contacts.internal.PhoneNumber;
import org.eclipse.sapphire.samples.contacts.internal.WebSite;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Contact
extends ModelElementForXml
implements IContact {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_ASSISTANT = new XmlPath("assistant", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_CATEGORY = new XmlPath("%category", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_E_MAIL = new XmlPath("e-mail", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_NAME = new XmlPath("@name", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_PHONE_NUMBERS = new XmlPath("phone-numbers", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_WEB_SITES = new XmlPath("web-sites", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private IAddress address = null;
    private IAssistant assistant = null;
    private boolean assistantCached = false;
    private XmlElement assistantElement = null;
    private Value<String> category = null;
    private ModelElementList<IConnection> connections = null;
    private Value<String> eMail = null;
    private Value<String> name = null;
    private ModelElementList<IPhoneNumber> phoneNumbers = null;
    private ModelElementList<IWebSite> webSites = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ASSISTANT, PATH_ASSISTANT);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_CATEGORY, PATH_CATEGORY);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_E_MAIL, PATH_E_MAIL);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_NAME, PATH_NAME);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_PHONE_NUMBERS, PATH_PHONE_NUMBERS);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_WEB_SITES, PATH_WEB_SITES);
    }

    public Contact(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAddress getAddress() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.address == null) {
                this.refresh((ModelProperty)PROP_ADDRESS, true);
            }
            return this.address;
        }
    }

    @Override
    public IAssistant getAssistant() {
        return this.getAssistant(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAssistant getAssistant(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (!this.assistantCached) {
                this.refresh((ModelProperty)PROP_ASSISTANT, true);
            }
            if (this.assistant == null && createIfNecessary) {
                this.validateEdit();
                this.getXmlElement(true).getChildNode(PATH_ASSISTANT, true);
                this.refresh((ModelProperty)PROP_ASSISTANT, true);
            }
            return this.assistant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCategory() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.category == null) {
                this.refresh((ModelProperty)PROP_CATEGORY, true);
            }
            return this.category;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCategory(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CATEGORY.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_CATEGORY, true);
            if (!Contact.equal((String)this.category.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_CATEGORY, value, true);
                this.refresh((ModelProperty)PROP_CATEGORY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IConnection> getConnections() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.connections == null) {
                this.refresh((ModelProperty)PROP_CONNECTIONS, true);
            }
            return this.connections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getEMail() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.eMail == null) {
                this.refresh((ModelProperty)PROP_E_MAIL, true);
            }
            return this.eMail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEMail(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_E_MAIL.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_E_MAIL, true);
            if (!Contact.equal((String)this.eMail.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_E_MAIL, value, true);
                this.refresh((ModelProperty)PROP_E_MAIL, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Contact.equal((String)this.name.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_NAME, value, true);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IPhoneNumber> getPhoneNumbers() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.phoneNumbers == null) {
                this.refresh((ModelProperty)PROP_PHONE_NUMBERS, true);
            }
            return this.phoneNumbers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IWebSite> getWebSites() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.webSites == null) {
                this.refresh((ModelProperty)PROP_WEB_SITES, true);
            }
            return this.webSites;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhoneNumbersByAreaCode(String areaCode) {
        IModel iModel = this.model;
        synchronized (iModel) {
            ContactMethods.removePhoneNumbersByAreaCode(this, areaCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ADDRESS) {
                boolean propertyEnabledStatusChanged;
                if (this.address == null && force) {
                    this.address = new Address((IModelParticle)this, (ModelProperty)PROP_ADDRESS);
                }
                if (propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ADDRESS)) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_ADDRESS);
                }
            } else if (property == PROP_ASSISTANT) {
                if (this.assistantCached || force) {
                    XmlNode child;
                    this.assistantCached = true;
                    IAssistant element = null;
                    XmlElement el = this.getXmlElement(false);
                    XmlNode xmlNode = child = el == null ? null : el.getChildNode(PATH_ASSISTANT, false);
                    if (child == null) {
                        this.assistantElement = null;
                    } else if (!child.equals((Object)this.assistantElement)) {
                        this.assistantElement = (XmlElement)child;
                        element = new Assistant((IModelParticle)this, (ModelProperty)PROP_ASSISTANT, this.assistantElement);
                    } else {
                        element = this.assistant;
                    }
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ASSISTANT);
                    if (this.assistant != element) {
                        if (this.assistant != null) {
                            this.assistant.dispose();
                        }
                        this.assistant = element;
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ASSISTANT);
                    } else if (propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ASSISTANT);
                    }
                }
            } else if (property == PROP_CATEGORY) {
                if (this.category != null || force) {
                    Value<String> oldValue = this.category;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_CATEGORY, false);
                    this.category = new Value((IModelElement)this, PROP_CATEGORY, PROP_CATEGORY.encodeKeywords(val));
                    this.category.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CATEGORY);
                    if (oldValue != null) {
                        if (this.category.equals(oldValue)) {
                            this.category = oldValue;
                        }
                        if (this.category != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CATEGORY);
                        }
                    }
                }
            } else if (property == PROP_CONNECTIONS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CONNECTIONS);
                if (this.connections == null && force) {
                    this.connections = new ModelElementList((IModelElement)this, PROP_CONNECTIONS);
                    ConnectionsListController controller = new ConnectionsListController();
                    controller.init((IModelElement)this, PROP_CONNECTIONS, this.connections, ((ListPropertyCustomBinding)PROP_CONNECTIONS.getAnnotation(ListPropertyCustomBinding.class)).params());
                    this.connections.init((ModelElementListController)controller);
                }
                if (this.connections != null && !(notified = this.connections.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_CONNECTIONS);
                }
            } else if (property == PROP_E_MAIL) {
                if (this.eMail != null || force) {
                    Value<String> oldValue = this.eMail;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_E_MAIL, false);
                    this.eMail = new Value((IModelElement)this, PROP_E_MAIL, PROP_E_MAIL.encodeKeywords(val));
                    this.eMail.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_E_MAIL);
                    if (oldValue != null) {
                        if (this.eMail.equals(oldValue)) {
                            this.eMail = oldValue;
                        }
                        if (this.eMail != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_E_MAIL);
                        }
                    }
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_NAME, false);
                    this.name = new Value((IModelElement)this, PROP_NAME, PROP_NAME.encodeKeywords(val));
                    this.name.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NAME);
                    if (oldValue != null) {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        }
                        if (this.name != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME);
                        }
                    }
                }
            } else if (property == PROP_PHONE_NUMBERS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PHONE_NUMBERS);
                if (this.phoneNumbers == null && force) {
                    this.phoneNumbers = new ModelElementList((IModelElement)this, PROP_PHONE_NUMBERS);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IPhoneNumber.TYPE, "phone-number");
                    ModelElementListControllerForXml<IPhoneNumber> controller = new ModelElementListControllerForXml<IPhoneNumber>(typeToElementName.values()){

                        protected IPhoneNumber wrap(XmlElement element) {
                            return new PhoneNumber((IModelParticle)this.getList(), (ModelProperty)PROP_PHONE_NUMBERS, element);
                        }

                        public IPhoneNumber createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            XmlElement parent = Contact.this.getXmlElement(createIfNecessary);
                            if (parent != null) {
                                parent = (XmlElement)parent.getChildNode(PATH_PHONE_NUMBERS, createIfNecessary);
                            }
                            return parent;
                        }

                        public void handleElementRemovedEvent() {
                            XmlElement parent;
                            XmlElement base = Contact.this.getXmlElement(false);
                            if (base != null && (parent = (XmlElement)base.getChildNode(PATH_PHONE_NUMBERS, false)) != null && parent.isEmpty()) {
                                base.removeChildNode(PATH_PHONE_NUMBERS);
                            }
                        }
                    };
                    controller.init((IModelElement)this, PROP_PHONE_NUMBERS, this.phoneNumbers, new String[0]);
                    this.phoneNumbers.init((ModelElementListController)controller);
                }
                if (this.phoneNumbers != null && !(notified = this.phoneNumbers.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_PHONE_NUMBERS);
                }
            } else if (property == PROP_WEB_SITES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_WEB_SITES);
                if (this.webSites == null && force) {
                    this.webSites = new ModelElementList((IModelElement)this, PROP_WEB_SITES);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IWebSite.TYPE, "web-site");
                    ModelElementListControllerForXml<IWebSite> controller = new ModelElementListControllerForXml<IWebSite>(typeToElementName.values()){

                        protected IWebSite wrap(XmlElement element) {
                            return new WebSite((IModelParticle)this.getList(), (ModelProperty)PROP_WEB_SITES, element);
                        }

                        public IWebSite createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            XmlElement parent = Contact.this.getXmlElement(createIfNecessary);
                            if (parent != null) {
                                parent = (XmlElement)parent.getChildNode(PATH_WEB_SITES, createIfNecessary);
                            }
                            return parent;
                        }

                        public void handleElementRemovedEvent() {
                            XmlElement parent;
                            XmlElement base = Contact.this.getXmlElement(false);
                            if (base != null && (parent = (XmlElement)base.getChildNode(PATH_WEB_SITES, false)) != null && parent.isEmpty()) {
                                base.removeChildNode(PATH_WEB_SITES);
                            }
                        }
                    };
                    controller.init((IModelElement)this, PROP_WEB_SITES, this.webSites, new String[0]);
                    this.webSites.init((ModelElementListController)controller);
                }
                if (this.webSites != null && !(notified = this.webSites.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_WEB_SITES);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

