/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.ezbug.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.ezbug.IBugReport;
import org.eclipse.sapphire.samples.ezbug.IHardwareItem;
import org.eclipse.sapphire.samples.ezbug.ProductStage;
import org.eclipse.sapphire.samples.ezbug.ProductVersion;
import org.eclipse.sapphire.samples.ezbug.internal.HardwareItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BugReport
extends ModelElementForXml
implements IBugReport {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_CUSTOMER_ID = new XmlPath("customer", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_DETAILS = new XmlPath("details", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_PRODUCT_STAGE = new XmlPath("stage", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_PRODUCT_VERSION = new XmlPath("version", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_TITLE = new XmlPath("title", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<String> customerId = null;
    private Value<String> details = null;
    private ModelElementList<IHardwareItem> hardware = null;
    private Value<ProductStage> productStage = null;
    private Value<ProductVersion> productVersion = null;
    private Value<String> title = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_CUSTOMER_ID, PATH_CUSTOMER_ID);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_DETAILS, PATH_DETAILS);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_PRODUCT_STAGE, PATH_PRODUCT_STAGE);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_PRODUCT_VERSION, PATH_PRODUCT_VERSION);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_TITLE, PATH_TITLE);
    }

    public BugReport(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCustomerId() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.customerId == null) {
                this.refresh((ModelProperty)PROP_CUSTOMER_ID, true);
            }
            return this.customerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomerId(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CUSTOMER_ID.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_CUSTOMER_ID, true);
            if (!BugReport.equal((String)this.customerId.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_CUSTOMER_ID, value, true);
                this.refresh((ModelProperty)PROP_CUSTOMER_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDetails() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.details == null) {
                this.refresh((ModelProperty)PROP_DETAILS, true);
            }
            return this.details;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDetails(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DETAILS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_DETAILS, true);
            if (!BugReport.equal((String)this.details.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_DETAILS, value, true);
                this.refresh((ModelProperty)PROP_DETAILS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IHardwareItem> getHardware() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.hardware == null) {
                this.refresh((ModelProperty)PROP_HARDWARE, true);
            }
            return this.hardware;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<ProductStage> getProductStage() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.productStage == null) {
                this.refresh((ModelProperty)PROP_PRODUCT_STAGE, true);
            }
            return this.productStage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProductStage(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PRODUCT_STAGE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_PRODUCT_STAGE, true);
            if (!BugReport.equal((String)this.productStage.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_PRODUCT_STAGE, value, true);
                this.refresh((ModelProperty)PROP_PRODUCT_STAGE, false);
            }
        }
    }

    @Override
    public void setProductStage(ProductStage value) {
        this.setProductStage(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_PRODUCT_STAGE, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<ProductVersion> getProductVersion() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.productVersion == null) {
                this.refresh((ModelProperty)PROP_PRODUCT_VERSION, true);
            }
            return this.productVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProductVersion(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PRODUCT_VERSION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_PRODUCT_VERSION, true);
            if (!BugReport.equal((String)this.productVersion.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_PRODUCT_VERSION, value, true);
                this.refresh((ModelProperty)PROP_PRODUCT_VERSION, false);
            }
        }
    }

    @Override
    public void setProductVersion(ProductVersion value) {
        this.setProductVersion(value != null ? ((ValueSerializationService)this.service(ValueSerializationService.class)).encode(PROP_PRODUCT_VERSION, (Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getTitle() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.title == null) {
                this.refresh((ModelProperty)PROP_TITLE, true);
            }
            return this.title;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TITLE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_TITLE, true);
            if (!BugReport.equal((String)this.title.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_TITLE, value, true);
                this.refresh((ModelProperty)PROP_TITLE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CUSTOMER_ID) {
                if (this.customerId != null || force) {
                    Value<String> oldValue = this.customerId;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_CUSTOMER_ID, false);
                    this.customerId = new Value((IModelElement)this, PROP_CUSTOMER_ID, PROP_CUSTOMER_ID.encodeKeywords(val));
                    this.customerId.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CUSTOMER_ID);
                    if (oldValue != null) {
                        if (this.customerId.equals(oldValue)) {
                            this.customerId = oldValue;
                        }
                        if (this.customerId != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CUSTOMER_ID);
                        }
                    }
                }
            } else if (property == PROP_DETAILS) {
                if (this.details != null || force) {
                    Value<String> oldValue = this.details;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_DETAILS, false);
                    this.details = new Value((IModelElement)this, PROP_DETAILS, PROP_DETAILS.encodeKeywords(val));
                    this.details.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_DETAILS);
                    if (oldValue != null) {
                        if (this.details.equals(oldValue)) {
                            this.details = oldValue;
                        }
                        if (this.details != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_DETAILS);
                        }
                    }
                }
            } else if (property == PROP_HARDWARE) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_HARDWARE);
                if (this.hardware == null && force) {
                    this.hardware = new ModelElementList((IModelElement)this, PROP_HARDWARE);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IHardwareItem.TYPE, "hardware-item");
                    ModelElementListControllerForXml<IHardwareItem> controller = new ModelElementListControllerForXml<IHardwareItem>(typeToElementName.values()){

                        protected IHardwareItem wrap(XmlElement element) {
                            return new HardwareItem((IModelParticle)this.getList(), (ModelProperty)PROP_HARDWARE, element);
                        }

                        public IHardwareItem createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            return BugReport.this.getXmlElement(createIfNecessary);
                        }
                    };
                    controller.init((IModelElement)this, PROP_HARDWARE, this.hardware, new String[0]);
                    this.hardware.init((ModelElementListController)controller);
                }
                if (this.hardware != null && !(notified = this.hardware.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_HARDWARE);
                }
            } else if (property == PROP_PRODUCT_STAGE) {
                if (this.productStage != null || force) {
                    Value<ProductStage> oldValue = this.productStage;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_PRODUCT_STAGE, false);
                    this.productStage = new Value((IModelElement)this, PROP_PRODUCT_STAGE, PROP_PRODUCT_STAGE.encodeKeywords(val));
                    this.productStage.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PRODUCT_STAGE);
                    if (oldValue != null) {
                        if (this.productStage.equals(oldValue)) {
                            this.productStage = oldValue;
                        }
                        if (this.productStage != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_PRODUCT_STAGE);
                        }
                    }
                }
            } else if (property == PROP_PRODUCT_VERSION) {
                if (this.productVersion != null || force) {
                    Value<ProductVersion> oldValue = this.productVersion;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_PRODUCT_VERSION, false);
                    this.productVersion = new Value((IModelElement)this, PROP_PRODUCT_VERSION, PROP_PRODUCT_VERSION.encodeKeywords(val));
                    this.productVersion.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PRODUCT_VERSION);
                    if (oldValue != null) {
                        if (this.productVersion.equals(oldValue)) {
                            this.productVersion = oldValue;
                        }
                        if (this.productVersion != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_PRODUCT_VERSION);
                        }
                    }
                }
            } else if (property == PROP_TITLE && (this.title != null || force)) {
                Value<String> oldValue = this.title;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_TITLE, false);
                this.title = new Value((IModelElement)this, PROP_TITLE, PROP_TITLE.encodeKeywords(val));
                this.title.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_TITLE);
                if (oldValue != null) {
                    if (this.title.equals(oldValue)) {
                        this.title = oldValue;
                    }
                    if (this.title != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TITLE);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

