/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zoo.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.zoo.IAddress;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Address
extends ModelElementForXml
implements IAddress {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_CITY = new XmlPath("city", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_STATE = new XmlPath("state", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_STREET = new XmlPath("street", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_ZIP_CODE = new XmlPath("zip", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<String> city = null;
    private Value<String> state = null;
    private Value<String> street = null;
    private Value<String> zipCode = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_CITY, PATH_CITY);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_STATE, PATH_STATE);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_STREET, PATH_STREET);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ZIP_CODE, PATH_ZIP_CODE);
    }

    public Address(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCity() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.city == null) {
                this.refresh((ModelProperty)PROP_CITY, true);
            }
            return this.city;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCity(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CITY.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_CITY, true);
            if (!Address.equal((String)this.city.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_CITY, value, true);
                this.refresh((ModelProperty)PROP_CITY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getState() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.state == null) {
                this.refresh((ModelProperty)PROP_STATE, true);
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STATE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_STATE, true);
            if (!Address.equal((String)this.state.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_STATE, value, true);
                this.refresh((ModelProperty)PROP_STATE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStreet() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.street == null) {
                this.refresh((ModelProperty)PROP_STREET, true);
            }
            return this.street;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStreet(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STREET.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_STREET, true);
            if (!Address.equal((String)this.street.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_STREET, value, true);
                this.refresh((ModelProperty)PROP_STREET, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getZipCode() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.zipCode == null) {
                this.refresh((ModelProperty)PROP_ZIP_CODE, true);
            }
            return this.zipCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZipCode(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ZIP_CODE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ZIP_CODE, true);
            if (!Address.equal((String)this.zipCode.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_ZIP_CODE, value, true);
                this.refresh((ModelProperty)PROP_ZIP_CODE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_CITY) {
                if (this.city != null || force) {
                    Value<String> oldValue = this.city;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_CITY, false);
                    this.city = new Value((IModelElement)this, PROP_CITY, PROP_CITY.encodeKeywords(val));
                    this.city.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CITY);
                    if (oldValue != null) {
                        if (this.city.equals(oldValue)) {
                            this.city = oldValue;
                        }
                        if (this.city != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CITY);
                        }
                    }
                }
            } else if (property == PROP_STATE) {
                if (this.state != null || force) {
                    Value<String> oldValue = this.state;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_STATE, false);
                    this.state = new Value((IModelElement)this, PROP_STATE, PROP_STATE.encodeKeywords(val));
                    this.state.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_STATE);
                    if (oldValue != null) {
                        if (this.state.equals(oldValue)) {
                            this.state = oldValue;
                        }
                        if (this.state != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_STATE);
                        }
                    }
                }
            } else if (property == PROP_STREET) {
                if (this.street != null || force) {
                    Value<String> oldValue = this.street;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_STREET, false);
                    this.street = new Value((IModelElement)this, PROP_STREET, PROP_STREET.encodeKeywords(val));
                    this.street.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_STREET);
                    if (oldValue != null) {
                        if (this.street.equals(oldValue)) {
                            this.street = oldValue;
                        }
                        if (this.street != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_STREET);
                        }
                    }
                }
            } else if (property == PROP_ZIP_CODE && (this.zipCode != null || force)) {
                Value<String> oldValue = this.zipCode;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_ZIP_CODE, false);
                this.zipCode = new Value((IModelElement)this, PROP_ZIP_CODE, PROP_ZIP_CODE.encodeKeywords(val));
                this.zipCode.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ZIP_CODE);
                if (oldValue != null) {
                    if (this.zipCode.equals(oldValue)) {
                        this.zipCode = oldValue;
                    }
                    if (this.zipCode != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ZIP_CODE);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

