/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zoo.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.ValuePropertyCustomBinding;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.zoo.IEmployee;
import org.eclipse.sapphire.samples.zoo.internal.EmployeeFullNamePropertyBinding;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Employee
extends ModelElementForXml
implements IEmployee {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_FIRST_NAME = new XmlPath("first-name", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_LAST_NAME = new XmlPath("last-name", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<String> firstName = null;
    private Value<String> fullName = null;
    private EmployeeFullNamePropertyBinding fullNameBinding = null;
    private Value<String> lastName = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_FIRST_NAME, PATH_FIRST_NAME);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_LAST_NAME, PATH_LAST_NAME);
    }

    public Employee(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getFirstName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.firstName == null) {
                this.refresh((ModelProperty)PROP_FIRST_NAME, true);
            }
            return this.firstName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFirstName(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_FIRST_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_FIRST_NAME, true);
            if (!Employee.equal((String)this.firstName.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_FIRST_NAME, value, true);
                this.refresh((ModelProperty)PROP_FIRST_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getFullName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.fullName == null) {
                this.refresh((ModelProperty)PROP_FULL_NAME, true);
            }
            return this.fullName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getLastName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.lastName == null) {
                this.refresh((ModelProperty)PROP_LAST_NAME, true);
            }
            return this.lastName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastName(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LAST_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LAST_NAME, true);
            if (!Employee.equal((String)this.lastName.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_LAST_NAME, value, true);
                this.refresh((ModelProperty)PROP_LAST_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_FIRST_NAME) {
                if (this.firstName != null || force) {
                    Value<String> oldValue = this.firstName;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_FIRST_NAME, false);
                    this.firstName = new Value((IModelElement)this, PROP_FIRST_NAME, PROP_FIRST_NAME.encodeKeywords(val));
                    this.firstName.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_FIRST_NAME);
                    if (oldValue != null) {
                        if (this.firstName.equals(oldValue)) {
                            this.firstName = oldValue;
                        }
                        if (this.firstName != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_FIRST_NAME);
                        }
                    }
                }
            } else if (property == PROP_FULL_NAME) {
                if (this.fullName != null || force) {
                    Value<String> oldValue = this.fullName;
                    if (this.fullNameBinding == null) {
                        this.fullNameBinding = new EmployeeFullNamePropertyBinding();
                        this.fullNameBinding.init((IModelElement)this, PROP_FULL_NAME, ((ValuePropertyCustomBinding)PROP_FULL_NAME.getAnnotation(ValuePropertyCustomBinding.class)).params());
                    }
                    String val = this.fullNameBinding.read();
                    this.fullName = new Value((IModelElement)this, PROP_FULL_NAME, PROP_FULL_NAME.encodeKeywords(val));
                    this.fullName.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_FULL_NAME);
                    if (oldValue != null) {
                        if (this.fullName.equals(oldValue)) {
                            this.fullName = oldValue;
                        }
                        if (this.fullName != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_FULL_NAME);
                        }
                    }
                }
            } else if (property == PROP_LAST_NAME && (this.lastName != null || force)) {
                Value<String> oldValue = this.lastName;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_LAST_NAME, false);
                this.lastName = new Value((IModelElement)this, PROP_LAST_NAME, PROP_LAST_NAME.encodeKeywords(val));
                this.lastName.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LAST_NAME);
                if (oldValue != null) {
                    if (this.lastName.equals(oldValue)) {
                        this.lastName = oldValue;
                    }
                    if (this.lastName != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_LAST_NAME);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

