/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.zoo.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListController;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.annotations.ListPropertyCustomBinding;
import org.eclipse.sapphire.modeling.xml.ModelElementListControllerForXml;
import org.eclipse.sapphire.modeling.xml.ModelForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.RootElementController;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.samples.zoo.IAddress;
import org.eclipse.sapphire.samples.zoo.IAnimal;
import org.eclipse.sapphire.samples.zoo.IEmployee;
import org.eclipse.sapphire.samples.zoo.IFinancialInfo;
import org.eclipse.sapphire.samples.zoo.IGiraffe;
import org.eclipse.sapphire.samples.zoo.ILion;
import org.eclipse.sapphire.samples.zoo.IStats;
import org.eclipse.sapphire.samples.zoo.IStructure;
import org.eclipse.sapphire.samples.zoo.IZooModel;
import org.eclipse.sapphire.samples.zoo.internal.Address;
import org.eclipse.sapphire.samples.zoo.internal.Employee;
import org.eclipse.sapphire.samples.zoo.internal.FinancialInfo;
import org.eclipse.sapphire.samples.zoo.internal.Giraffe;
import org.eclipse.sapphire.samples.zoo.internal.Lion;
import org.eclipse.sapphire.samples.zoo.internal.Stats;
import org.eclipse.sapphire.samples.zoo.internal.StructuresModelElementListController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZooModel
extends ModelForXml
implements IZooModel {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_ADDRESS = new XmlPath("address", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_ANIMALS = new XmlPath("animals", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_EMPLOYEES = new XmlPath("employees", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_NAME = new XmlPath("name", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private IAddress address = null;
    private boolean addressCached = false;
    private XmlElement addressElement = null;
    private ModelElementList<IAnimal> animals = null;
    private ModelElementList<IEmployee> employees = null;
    private IFinancialInfo financialInfo = null;
    private Value<String> name = null;
    private IStats stats = null;
    private ModelElementList<IStructure> structures = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ADDRESS, PATH_ADDRESS);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ANIMALS, PATH_ANIMALS);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_EMPLOYEES, PATH_EMPLOYEES);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_NAME, PATH_NAME);
    }

    public ZooModel(ModelStoreForXml modelStore) {
        super(TYPE, modelStore);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerRootModelElement((IModelElement)this);
    }

    protected RootElementController createRootElementController() {
        return new StandardRootElementController("http://www.eclipse.org/sapphire/samples/zoo", null, "z", "zoo");
    }

    @Override
    public IAddress getAddress() {
        return this.getAddress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAddress getAddress(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (!this.addressCached) {
                this.refresh((ModelProperty)PROP_ADDRESS, true);
            }
            if (this.address == null && createIfNecessary) {
                this.validateEdit();
                this.getXmlElement(true).getChildNode(PATH_ADDRESS, true);
                this.refresh((ModelProperty)PROP_ADDRESS, true);
            }
            return this.address;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IAnimal> getAnimals() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.animals == null) {
                this.refresh((ModelProperty)PROP_ANIMALS, true);
            }
            return this.animals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IEmployee> getEmployees() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.employees == null) {
                this.refresh((ModelProperty)PROP_EMPLOYEES, true);
            }
            return this.employees;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFinancialInfo getFinancialInfo() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.financialInfo == null) {
                this.refresh((ModelProperty)PROP_FINANCIAL_INFO, true);
            }
            return this.financialInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!ZooModel.equal((String)this.name.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_NAME, value, true);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStats getStats() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.stats == null) {
                this.refresh((ModelProperty)PROP_STATS, true);
            }
            return this.stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IStructure> getStructures() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.structures == null) {
                this.refresh((ModelProperty)PROP_STRUCTURES, true);
            }
            return this.structures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ADDRESS) {
                if (this.addressCached || force) {
                    XmlNode child;
                    this.addressCached = true;
                    IAddress element = null;
                    XmlElement el = this.getXmlElement(false);
                    XmlNode xmlNode = child = el == null ? null : el.getChildNode(PATH_ADDRESS, false);
                    if (child == null) {
                        this.addressElement = null;
                    } else if (!child.equals((Object)this.addressElement)) {
                        this.addressElement = (XmlElement)child;
                        element = new Address((IModelParticle)this, (ModelProperty)PROP_ADDRESS, this.addressElement);
                    } else {
                        element = this.address;
                    }
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ADDRESS);
                    if (this.address != element) {
                        if (this.address != null) {
                            this.address.dispose();
                        }
                        this.address = element;
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ADDRESS);
                    } else if (propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ADDRESS);
                    }
                }
            } else if (property == PROP_ANIMALS) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ANIMALS);
                if (this.animals == null && force) {
                    this.animals = new ModelElementList((IModelElement)this, PROP_ANIMALS);
                    final HashMap<ModelElementType, String> typeToElementName = new HashMap<ModelElementType, String>();
                    typeToElementName.put(IGiraffe.TYPE, "giraffe");
                    typeToElementName.put(ILion.TYPE, "lion");
                    ModelElementListControllerForXml<IAnimal> controller = new ModelElementListControllerForXml<IAnimal>(typeToElementName.values()){

                        protected IAnimal wrap(XmlElement element) {
                            String elementName = element.getLocalName();
                            if (elementName.equals("giraffe")) {
                                return new Giraffe((IModelParticle)this.getList(), (ModelProperty)PROP_ANIMALS, element);
                            }
                            if (elementName.equals("lion")) {
                                return new Lion((IModelParticle)this.getList(), (ModelProperty)PROP_ANIMALS, element);
                            }
                            throw new IllegalArgumentException();
                        }

                        public IAnimal createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            XmlElement parent = ZooModel.this.getXmlElement(createIfNecessary);
                            if (parent != null) {
                                parent = (XmlElement)parent.getChildNode(PATH_ANIMALS, createIfNecessary);
                            }
                            return parent;
                        }

                        public void handleElementRemovedEvent() {
                            XmlElement parent;
                            XmlElement base = ZooModel.this.getXmlElement(false);
                            if (base != null && (parent = (XmlElement)base.getChildNode(PATH_ANIMALS, false)) != null && parent.isEmpty()) {
                                base.removeChildNode(PATH_ANIMALS);
                            }
                        }
                    };
                    controller.init((IModelElement)this, PROP_ANIMALS, this.animals, new String[0]);
                    this.animals.init((ModelElementListController)controller);
                }
                if (this.animals != null && !(notified = this.animals.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_ANIMALS);
                }
            } else if (property == PROP_EMPLOYEES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_EMPLOYEES);
                if (this.employees == null && force) {
                    this.employees = new ModelElementList((IModelElement)this, PROP_EMPLOYEES);
                    final Map<ModelElementType, String> typeToElementName = Collections.singletonMap(IEmployee.TYPE, "employee");
                    ModelElementListControllerForXml<IEmployee> controller = new ModelElementListControllerForXml<IEmployee>(typeToElementName.values()){

                        protected IEmployee wrap(XmlElement element) {
                            return new Employee((IModelParticle)this.getList(), (ModelProperty)PROP_EMPLOYEES, element);
                        }

                        public IEmployee createNewElement(ModelElementType type) {
                            this.validateEdit();
                            String elementName = (String)typeToElementName.get(type);
                            return this.wrap(this.getParentXmlElement(true).addChildElement(elementName));
                        }

                        protected XmlElement getParentXmlElement(boolean createIfNecessary) {
                            XmlElement parent = ZooModel.this.getXmlElement(createIfNecessary);
                            if (parent != null) {
                                parent = (XmlElement)parent.getChildNode(PATH_EMPLOYEES, createIfNecessary);
                            }
                            return parent;
                        }

                        public void handleElementRemovedEvent() {
                            XmlElement parent;
                            XmlElement base = ZooModel.this.getXmlElement(false);
                            if (base != null && (parent = (XmlElement)base.getChildNode(PATH_EMPLOYEES, false)) != null && parent.isEmpty()) {
                                base.removeChildNode(PATH_EMPLOYEES);
                            }
                        }
                    };
                    controller.init((IModelElement)this, PROP_EMPLOYEES, this.employees, new String[0]);
                    this.employees.init((ModelElementListController)controller);
                }
                if (this.employees != null && !(notified = this.employees.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_EMPLOYEES);
                }
            } else if (property == PROP_FINANCIAL_INFO) {
                boolean propertyEnabledStatusChanged;
                if (this.financialInfo == null && force) {
                    this.financialInfo = new FinancialInfo((IModelParticle)this, (ModelProperty)PROP_FINANCIAL_INFO);
                }
                if (propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_FINANCIAL_INFO)) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_FINANCIAL_INFO);
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_NAME, false);
                    this.name = new Value((IModelElement)this, PROP_NAME, PROP_NAME.encodeKeywords(val));
                    this.name.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NAME);
                    if (oldValue != null) {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        }
                        if (this.name != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME);
                        }
                    }
                }
            } else if (property == PROP_STATS) {
                boolean propertyEnabledStatusChanged;
                if (this.stats == null && force) {
                    this.stats = new Stats((IModelElement)this, (ModelProperty)PROP_STATS);
                }
                if (propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_STATS)) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_STATS);
                }
            } else if (property == PROP_STRUCTURES) {
                boolean notified;
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_STRUCTURES);
                if (this.structures == null && force) {
                    this.structures = new ModelElementList((IModelElement)this, PROP_STRUCTURES);
                    StructuresModelElementListController controller = new StructuresModelElementListController();
                    controller.init((IModelElement)this, PROP_STRUCTURES, this.structures, ((ListPropertyCustomBinding)PROP_STRUCTURES.getAnnotation(ListPropertyCustomBinding.class)).params());
                    this.structures.init((ModelElementListController)controller);
                }
                if (this.structures != null && !(notified = this.structures.refresh()) && propertyEnabledStatusChanged) {
                    this.notifyPropertyChangeListeners((ModelProperty)PROP_STRUCTURES);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

