/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.annotations.ImageProvider;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class SapphireImageCache {
    public static final ImageDescriptor OVERLAY_ERROR = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/overlays/error.gif");
    public static final ImageDescriptor OVERLAY_WARNING = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/overlays/warning.png");
    public static final ImageDescriptor DECORATOR_ASSIST = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/decorators/assist.png");
    public static final ImageDescriptor DECORATOR_ASSIST_FAINT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/decorators/assist-faint.png");
    public static final ImageDescriptor DECORATOR_BLANK = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/decorators/blank.png");
    public static final ImageDescriptor ACTION_ADD = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/add.png");
    public static final ImageDescriptor ACTION_EDIT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/edit.png");
    public static final ImageDescriptor ACTION_DELETE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/delete.png");
    public static final ImageDescriptor ACTION_MOVE_UP = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/move-up.png");
    public static final ImageDescriptor ACTION_MOVE_DOWN = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/move-down.png");
    public static final ImageDescriptor ACTION_MOVE_LEFT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/move-left.png");
    public static final ImageDescriptor ACTION_MOVE_RIGHT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/move-right.png");
    public static final ImageDescriptor ACTION_EXPAND_ALL = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/expand-all.png");
    public static final ImageDescriptor ACTION_COLLAPSE_ALL = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/collapse-all.png");
    public static final ImageDescriptor ACTION_RESTORE_DEFAULTS = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/restore-defaults.png");
    public static final ImageDescriptor ACTION_BROWSE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/browse.png");
    public static final ImageDescriptor ACTION_BROWSE_MINI = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/browse-mini.png");
    public static final ImageDescriptor ACTION_SELECT_ALL = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/select-all.png");
    public static final ImageDescriptor ACTION_DESELECT_ALL = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/deselect-all.png");
    public static final ImageDescriptor ACTION_SHOW_XML_EDITOR_PAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/show-xml-editor-page.png");
    public static final ImageDescriptor ACTION_SHOW_IN_SOURCE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/show-in-source.png");
    public static final ImageDescriptor ACTION_SHOW_HELP = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_LCL_LINKTO_HELP");
    public static final ImageDescriptor ACTION_DEFAULT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/default.png");
    public static final ImageDescriptor ACTION_HIDE_OUTLINE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/actions/hide-outline.png");
    public static final ImageDescriptor OBJECT_FILE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/file.png");
    public static final ImageDescriptor OBJECT_FOLDER = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/folder.png");
    public static final ImageDescriptor OBJECT_PACKAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/package.png");
    public static final ImageDescriptor OBJECT_CONTAINER_NODE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/container-node.png");
    public static final ImageDescriptor OBJECT_LEAF_NODE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/leaf-node.png");
    public static final ImageDescriptor OBJECT_CHECK_ON = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/check-on.gif");
    public static final ImageDescriptor OBJECT_CHECK_OFF = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sapphire.ui", (String)"images/objects/check-off.gif");
    public static final ImageDescriptor OBJECT_ERROR = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
    public static final ImageDescriptor OBJECT_WARNING = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK");
    private final Map<ImageDescriptor, ImageHandle> imageDescToImageHandle = new HashMap<ImageDescriptor, ImageHandle>();
    private final Map<Class<? extends ImageProvider>, ImageProvider> imageProviderInstances = new WeakHashMap<Class<? extends ImageProvider>, ImageProvider>();

    public Image getImage(ImageDescriptor imageDescriptor) {
        return this.getImage(imageDescriptor, 0);
    }

    public Image getImage(ImageDescriptor imageDescriptor, int problemSeverity) {
        ImageHandle imageHandle = this.imageDescToImageHandle.get(imageDescriptor);
        if (imageHandle == null) {
            imageHandle = new ImageHandle(imageDescriptor);
            this.imageDescToImageHandle.put(imageDescriptor, imageHandle);
        }
        return imageHandle.getImage(problemSeverity);
    }

    public Image getImage(String imagePath) {
        return this.getImage(imagePath, 0);
    }

    public Image getImage(String imagePath, int problemSeverity) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(imagePath);
        if (imageDescriptor != null) {
            return this.getImage(imageDescriptor, problemSeverity);
        }
        return null;
    }

    public Image getImage(ModelElementType type) {
        return this.getImage(type, 0);
    }

    public Image getImage(ModelElementType type, int problemSeverity) {
        return this.getImage(type, null, problemSeverity);
    }

    public Image getImage(IModelElement element) {
        return this.getImage(element, 0);
    }

    public Image getImage(IModelElement element, int problemSeverity) {
        return this.getImage(element.getModelElementType(), element, problemSeverity);
    }

    private Image getImage(ModelElementType type, IModelElement element, int problemSeverity) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(type, element);
        if (imageDescriptor != null) {
            return this.getImage(imageDescriptor, problemSeverity);
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(String imagePath) {
        String relPath;
        int slash = imagePath.indexOf(47);
        String pluginId = imagePath.substring(0, slash);
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)(relPath = imagePath.substring(slash + 1)));
        if (imageDescriptor == null) {
            String msg = NLS.bind((String)Resources.couldNotLoadImage, (Object)imagePath);
            SapphireUiFrameworkPlugin.logError(msg, null);
        }
        return imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor(ModelElementType type) {
        return this.getImageDescriptor(type, null);
    }

    public ImageDescriptor getImageDescriptor(IModelElement element) {
        return this.getImageDescriptor(element.getModelElementType(), element);
    }

    private ImageDescriptor getImageDescriptor(ModelElementType type, IModelElement element) {
        org.eclipse.sapphire.modeling.annotations.Image imageAnnotation = (org.eclipse.sapphire.modeling.annotations.Image)type.getAnnotation(org.eclipse.sapphire.modeling.annotations.Image.class);
        if (imageAnnotation != null) {
            String imagePath = null;
            if (imageAnnotation.provider() != ImageProvider.class) {
                Class imageProviderClass = imageAnnotation.provider();
                ImageProvider imageProvider = this.imageProviderInstances.get(imageProviderClass);
                if (imageProvider == null) {
                    try {
                        imageProvider = (ImageProvider)imageProviderClass.newInstance();
                    }
                    catch (Exception e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                    if (imageProvider != null) {
                        this.imageProviderInstances.put(imageProviderClass, imageProvider);
                    }
                }
                if (imageProvider != null) {
                    imagePath = element != null ? imageProvider.getSmallImagePath(element) : imageProvider.getSmallImagePath(type);
                }
            } else if (imageAnnotation.small().length() > 0) {
                imagePath = imageAnnotation.small();
            }
            return this.getImageDescriptor(imagePath);
        }
        return null;
    }

    public void dispose() {
        for (ImageHandle imageHandle : this.imageDescToImageHandle.values()) {
            imageHandle.dispose();
        }
    }

    private static final class ImageHandle {
        private final ImageDescriptor baseImageDescriptor;
        private Image baseImage;
        private Image warningImage;
        private Image errorImage;

        public ImageHandle(ImageDescriptor baseImageDescriptor) {
            this.baseImageDescriptor = baseImageDescriptor;
        }

        public Image getImage(int severity) {
            if (this.baseImageDescriptor == null) {
                return null;
            }
            if (severity == 4) {
                if (this.errorImage == null) {
                    ProblemOverlayImageDescriptor desc = new ProblemOverlayImageDescriptor(this.baseImageDescriptor, 4);
                    this.errorImage = desc.createImage();
                }
                return this.errorImage;
            }
            if (severity == 2) {
                if (this.warningImage == null) {
                    ProblemOverlayImageDescriptor desc = new ProblemOverlayImageDescriptor(this.baseImageDescriptor, 2);
                    this.warningImage = desc.createImage();
                }
                return this.warningImage;
            }
            if (this.baseImage == null) {
                this.baseImage = this.baseImageDescriptor.createImage();
            }
            return this.baseImage;
        }

        public void dispose() {
            if (this.baseImage != null) {
                this.baseImage.dispose();
            }
            if (this.errorImage != null) {
                this.errorImage.dispose();
            }
            if (this.warningImage != null) {
                this.warningImage.dispose();
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String couldNotLoadImage;

        static {
            Resources.initializeMessages((String)SapphireImageCache.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

