/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionLink;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireDialogPart;
import org.eclipse.sapphire.ui.SapphireElementPropertyComposite;
import org.eclipse.sapphire.ui.SapphireEnumControlledPageBook;
import org.eclipse.sapphire.ui.SapphireGroup;
import org.eclipse.sapphire.ui.SapphireIfElseDirective;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphireLabel;
import org.eclipse.sapphire.ui.SapphireListControlledPageBook;
import org.eclipse.sapphire.ui.SapphirePartContext;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSeparator;
import org.eclipse.sapphire.ui.SapphireSpacer;
import org.eclipse.sapphire.ui.SapphireStaticTextField;
import org.eclipse.sapphire.ui.SapphireTabGroup;
import org.eclipse.sapphire.ui.SapphireWithDirective;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.def.ICompositeParam;
import org.eclipse.sapphire.ui.def.ISapphireActionLinkDef;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireCompositeRef;
import org.eclipse.sapphire.ui.def.ISapphireCustomPartDef;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.ISapphireElementPropertyCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireGroupDef;
import org.eclipse.sapphire.ui.def.ISapphireIfElseDirectiveDef;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.def.ISapphirePageBookExtDef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphirePartListenerDef;
import org.eclipse.sapphire.ui.def.ISapphirePropertyEditorDef;
import org.eclipse.sapphire.ui.def.ISapphireSeparatorDef;
import org.eclipse.sapphire.ui.def.ISapphireSpacerDef;
import org.eclipse.sapphire.ui.def.ISapphireStaticTextFieldDef;
import org.eclipse.sapphire.ui.def.ISapphireTabGroupDef;
import org.eclipse.sapphire.ui.def.ISapphireWithDirectiveDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardPageDef;
import org.eclipse.sapphire.ui.def.PageBookPartControlMethod;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphirePart
implements ISapphirePart {
    private ISapphirePart parent;
    private IModelElement modelElement;
    protected ISapphirePartDef definition;
    protected Map<String, String> params;
    private ModelElementListener modelElementListener;
    private IStatus validationState;
    private Set<SapphirePartListener> listeners;
    private SapphireImageCache imageCache;

    public final void init(ISapphirePart parent, IModelElement modelElement, ISapphirePartDef definition, Map<String, String> params) {
        this.parent = parent;
        this.definition = definition;
        this.params = params;
        SapphireImageCache sapphireImageCache = this.imageCache = this.parent == null ? new SapphireImageCache() : this.parent.getImageCache();
        if (modelElement == null) {
            throw new IllegalArgumentException();
        }
        this.modelElement = modelElement;
        this.modelElementListener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                SapphirePart.this.handleModelElementChange(event);
            }
        };
        this.modelElement.addListener(this.modelElementListener);
        this.validationState = Status.OK_STATUS;
        this.listeners = null;
        for (ISapphirePartListenerDef listenerDefinition : definition.getListeners()) {
            Class listenerClass = (Class)listenerDefinition.getListenerClass().resolve();
            if (listenerClass == null) continue;
            Object listener = null;
            try {
                listener = listenerClass.newInstance();
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Resources.failedToInstantiate, (Object)listenerClass.getName());
                SapphireUiFrameworkPlugin.logError(msg, e);
            }
            if (listener == null) continue;
            if (listener instanceof SapphirePartListener) {
                this.addListener(listener);
                continue;
            }
            String msg = NLS.bind((String)Resources.doesNotExtend, (Object)listenerClass.getName());
            SapphireUiFrameworkPlugin.logError(msg);
        }
        this.init();
        this.updateValidationState();
    }

    protected void init() {
    }

    public abstract void render(SapphireRenderingContext var1);

    public ISapphirePartDef getDefinition() {
        return this.definition;
    }

    @Override
    public final ISapphirePart getParentPart() {
        return this.parent;
    }

    @Override
    public final <T> T getNearestPart(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.getNearestPart(partType);
        }
        return null;
    }

    @Override
    public final IModelElement getModelElement() {
        return this.modelElement;
    }

    @Override
    public Action getAction(String id) {
        if (this.parent != null) {
            return this.parent.getAction(id);
        }
        return null;
    }

    @Override
    public final IStatus getValidationState() {
        return this.validationState;
    }

    protected IStatus computeValidationState() {
        return Status.OK_STATUS;
    }

    public final void updateValidationState() {
        IStatus newValidationState = this.computeValidationState();
        boolean updateNeeded = false;
        if (this.validationState != newValidationState) {
            if (this.validationState == null || newValidationState == null) {
                updateNeeded = true;
            } else if (this.validationState.getSeverity() != newValidationState.getSeverity() || !this.validationState.getMessage().equals(newValidationState.getMessage())) {
                updateNeeded = true;
            }
        }
        if (updateNeeded) {
            IStatus oldValidationState = this.validationState;
            this.validationState = newValidationState;
            if (this.listeners != null) {
                for (SapphirePartListener listener : this.listeners) {
                    try {
                        listener.handleValidateStateChange(oldValidationState, newValidationState);
                    }
                    catch (Exception e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
            }
        }
    }

    public boolean setFocus() {
        return false;
    }

    public boolean setFocus(ModelPath path) {
        return false;
    }

    public final boolean setFocus(String path) {
        return this.setFocus(new ModelPath(path));
    }

    protected final void notifyFocusRecievedEventListeners() {
        if (this.listeners != null) {
            SapphirePartEvent event = new SapphirePartEvent(new SapphirePartContext(this));
            for (SapphirePartListener listener : this.listeners) {
                try {
                    listener.handleFocusReceivedEvent(event);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
    }

    @Override
    public String getHelpContextId() {
        return null;
    }

    @Override
    public SapphireImageCache getImageCache() {
        return this.imageCache;
    }

    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
    }

    @Override
    public final void addListener(SapphirePartListener listener) {
        if (this.listeners == null) {
            this.listeners = Collections.singleton(listener);
        } else {
            this.listeners = new HashSet<SapphirePartListener>(this.listeners);
            this.listeners.add(listener);
        }
    }

    @Override
    public final void removeListener(SapphirePartListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            if (this.listeners.size() == 1) {
                this.listeners = null;
            } else {
                this.listeners = new HashSet<SapphirePartListener>(this.listeners);
                this.listeners.remove(listener);
            }
        }
    }

    public final Set<SapphirePartListener> getListeners() {
        if (this.listeners == null) {
            return Collections.emptySet();
        }
        return this.listeners;
    }

    public final void notifyStructureChangedEventListeners(SapphirePartEvent event) {
        if (this.listeners != null) {
            for (SapphirePartListener listener : this.listeners) {
                try {
                    listener.handleStructureChangedEvent(event);
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        }
        if (this.parent != null && this.parent instanceof SapphirePart) {
            ((SapphirePart)this.parent).notifyStructureChangedEventListeners(event);
        }
    }

    public final ModelProperty resolve(String propertyName) {
        return this.resolve(this.modelElement, propertyName);
    }

    public final ModelProperty resolve(IModelElement modelElement, String propertyName) {
        if (propertyName != null) {
            ModelElementType type;
            ModelProperty property;
            if ((propertyName = propertyName.trim()).startsWith("@{") && propertyName.endsWith("}")) {
                propertyName = propertyName.substring(2, propertyName.length() - 1);
                propertyName = this.params.get(propertyName);
            }
            if ((property = (type = modelElement.getModelElementType()).getProperty(propertyName)) == null) {
                throw new RuntimeException("Could not find property " + propertyName + " in " + type.getQualifiedName());
            }
            return property;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.modelElement.removeListener(this.modelElementListener);
        if (this.parent == null) {
            this.imageCache.dispose();
        }
    }

    public static final SapphirePart create(SapphirePart parent, IModelElement modelElement, ISapphirePartDef definition, Map<String, String> params) {
        if (modelElement == null) {
            throw new IllegalArgumentException();
        }
        SapphirePart part = null;
        Map<String, String> partParams = params;
        ISapphirePartDef def = definition;
        if (definition instanceof ISapphirePropertyEditorDef) {
            part = new SapphirePropertyEditor();
        } else if (definition instanceof ISapphireLabelDef) {
            part = new SapphireLabel();
        } else if (definition instanceof ISapphireSeparatorDef) {
            part = new SapphireSeparator();
        } else if (definition instanceof ISapphireSpacerDef) {
            part = new SapphireSpacer();
        } else if (definition instanceof ISapphireActionLinkDef) {
            part = new SapphireActionLink();
        } else if (definition instanceof ISapphireCustomPartDef) {
            Class customPartImplClass = (Class)((ISapphireCustomPartDef)definition).getImplClass().resolve();
            if (customPartImplClass != null) {
                try {
                    part = (SapphirePart)customPartImplClass.newInstance();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                }
            }
        } else if (definition instanceof ISapphireStaticTextFieldDef) {
            part = new SapphireStaticTextField();
        } else if (definition instanceof ISapphireGroupDef) {
            part = new SapphireGroup();
        } else if (definition instanceof ISapphireWithDirectiveDef) {
            part = new SapphireWithDirective();
        } else if (definition instanceof ISapphirePageBookExtDef) {
            ISapphirePageBookExtDef pageBookPartDef = (ISapphirePageBookExtDef)definition;
            part = pageBookPartDef.getControlMethod().getContent() == PageBookPartControlMethod.ENUM_VALUE ? new SapphireEnumControlledPageBook() : new SapphireListControlledPageBook();
        } else if (definition instanceof ISapphireElementPropertyCompositeDef) {
            part = new SapphireElementPropertyComposite();
        } else if (definition instanceof ISapphireDialogDef) {
            part = new SapphireDialogPart();
        } else if (definition instanceof ISapphireWizardPageDef) {
            part = new SapphireWizardPagePart();
        } else if (definition instanceof ISapphireCompositeDef) {
            part = new SapphireComposite();
        } else if (definition instanceof ISapphireCompositeRef) {
            ISapphireCompositeRef compositeRef = (ISapphireCompositeRef)definition;
            def = compositeRef.resolve();
            if (def != null) {
                partParams = new HashMap<String, String>(params);
                for (ICompositeParam param : compositeRef.getParams()) {
                    String paramName = param.getName().getText();
                    String paramValue = param.getValue().getText();
                    if (paramName == null || paramValue == null) continue;
                    partParams.put(paramName, paramValue);
                }
                part = new SapphireComposite();
            }
        } else if (definition instanceof ISapphireTabGroupDef) {
            part = new SapphireTabGroup();
        } else if (definition instanceof ISapphireIfElseDirectiveDef) {
            part = new SapphireIfElseDirective();
        }
        if (part == null) {
            throw new IllegalStateException();
        }
        part.init(parent, modelElement, def, partParams);
        return part;
    }

    private static final class Resources
    extends NLS {
        public static String failedToInstantiate;
        public static String doesNotExtend;

        static {
            Resources.initializeMessages((String)SapphirePart.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

