/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.SapphireComposite;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphirePartContext;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.actions.ActionGroup;
import org.eclipse.sapphire.ui.actions.ActionsRenderer;
import org.eclipse.sapphire.ui.actions.RestoreDefaultsAction;
import org.eclipse.sapphire.ui.actions.ShowHelpAction;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.internal.ActionsHostUtil;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireSection
extends SapphireComposite {
    private ISapphireSectionDef definition;
    private List<ActionGroup> actions = null;
    private SapphireCondition visibleWhenCondition;

    @Override
    protected void init() {
        super.init();
        this.definition = (ISapphireSectionDef)((SapphireComposite)this).definition;
        this.visibleWhenCondition = null;
        Class visibleWhenConditionClass = (Class)this.definition.getVisibleWhenConditionClass().resolve();
        if (visibleWhenConditionClass != null) {
            try {
                this.visibleWhenCondition = (SapphireCondition)visibleWhenConditionClass.newInstance();
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            if (this.visibleWhenCondition != null) {
                String parameter = this.definition.getVisibleWhenConditionParameter().getText();
                this.visibleWhenCondition.init(new SapphirePartContext(this), parameter);
            }
        }
    }

    @Override
    protected Composite createOuterComposite(SapphireRenderingContext context) {
        String title = this.definition.getLabel().getLocalizedText();
        String description = this.definition.getDescription().getLocalizedText();
        FormToolkit toolkit = new FormToolkit(context.getDisplay());
        Section section = toolkit.createSection(context.getComposite(), 256);
        section.setLayoutData((Object)TableWrapLayoutUtil.twd());
        section.setText(title.trim());
        Composite outerComposite = new Composite((Composite)section, 0);
        outerComposite.setLayout((Layout)TableWrapLayoutUtil.twlayout(1, 0, 0, 0, 0));
        context.adapt((Control)outerComposite);
        if (description != null) {
            Label descriptionControl = new Label(outerComposite, 64);
            descriptionControl.setLayoutData((Object)TableWrapLayoutUtil.twdindent(TableWrapLayoutUtil.twd(), 9));
            descriptionControl.setText(description.trim());
        }
        Composite innerComposite = new Composite(outerComposite, 0);
        innerComposite.setLayout((Layout)SwtUtil.glayout(2, 0, 0, description != null ? 8 : 0, 0));
        innerComposite.setLayoutData((Object)TableWrapLayoutUtil.twd());
        context.adapt((Control)innerComposite);
        ToolBar toolbar = new ToolBar((Composite)section, 0x800100);
        ActionsRenderer.fillToolBar(toolbar, this.getActions());
        section.setTextClient((Control)toolbar);
        toolkit.paintBordersFor((Composite)section);
        section.setClient((Control)outerComposite);
        return innerComposite;
    }

    public List<ActionGroup> getActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<ActionGroup>();
            ActionGroup systemActionsGroup = new ActionGroup();
            systemActionsGroup.addAction(new RestoreDefaultsAction());
            systemActionsGroup.addAction(new ShowHelpAction());
            this.actions.add(systemActionsGroup);
            ActionsHostUtil.initActions(this.actions, this.definition.getActionSetDef());
            for (ActionGroup group : this.actions) {
                for (Action action : group.getActions()) {
                    action.setPart(this);
                }
            }
        }
        return this.actions;
    }

    @Override
    public Action getAction(String id) {
        return super.getAction(id);
    }

    @Override
    public String getHelpContextId() {
        return this.definition.getHelpContextId().getText();
    }

    public SapphireCondition getVisibleWhenCondition() {
        return this.visibleWhenCondition;
    }

    public boolean checkVisibleWhenCondition() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.evaluate();
        }
        return true;
    }
}

