/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesChangedEvent;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderImpl;
import org.eclipse.sapphire.modeling.annotations.PossibleValuesProviderListener;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.actions.Action;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.AbstractSlushBucketPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.util.SwtUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class SlushBucketPropertyEditor
extends AbstractSlushBucketPropertyEditorRenderer {
    private ModelElementType memberType = this.getProperty().getType();
    private ValueProperty memberProperty = (ValueProperty)this.memberType.getProperties().get(0);
    private PossibleValuesProviderImpl valuesProvider = null;
    private PossibleValuesProviderListener valuesProviderListener = null;
    private TableViewer sourceTableViewer = null;
    private Table sourceTable = null;
    private AddAction addAction = null;

    public SlushBucketPropertyEditor(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
        this.valuesProvider = part.getModelElement().service().getPossibleValuesProvider(this.memberProperty);
        this.setAddActionDesired(false);
    }

    public Control createSourceControl(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SwtUtil.glayout(1, 0, 0));
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)SwtUtil.gdwhint(SwtUtil.gdfill(), 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        innerComposite.setLayout((Layout)tableColumnLayout);
        this.sourceTableViewer = new TableViewer(innerComposite, 67586);
        this.sourceTable = this.sourceTableViewer.getTable();
        this.sourceTable.setHeaderVisible(true);
        TableViewerColumn viewerColumn = new TableViewerColumn(this.sourceTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(this.memberProperty.getLabel(false, CapitalizationType.TITLE_STYLE, false));
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 100, true));
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                SortedSet allValues;
                if (SlushBucketPropertyEditor.this.valuesProvider == null) {
                    return new Object[0];
                }
                ModelElementList<IModelElement> list = SlushBucketPropertyEditor.this.getList();
                if (list == null) {
                    return new Object[0];
                }
                try {
                    allValues = SlushBucketPropertyEditor.this.valuesProvider.getPossibleValues();
                }
                catch (Exception e) {
                    SapphireUiFrameworkPlugin.log(e);
                    return new Object[0];
                }
                HashSet<String> valuesToRemove = new HashSet<String>();
                for (IModelElement member : list) {
                    Value value = (Value)SlushBucketPropertyEditor.this.memberProperty.invokeGetterMethod((Object)member);
                    String str = value.getText();
                    if (str == null) continue;
                    valuesToRemove.add(str);
                }
                HashSet values = new HashSet(allValues);
                values.removeAll(valuesToRemove);
                return values.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        this.sourceTableViewer.setContentProvider((IContentProvider)contentProvider);
        final Image memberTypeImage = part.getImageCache().getImage(this.memberType);
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }

            public Image getImage(Object element) {
                return memberTypeImage;
            }
        };
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        SwtUtil.makeTableSortable(this.sourceTableViewer);
        this.sourceTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                SlushBucketPropertyEditor.this.handleSourceTableDoubleClickEvent(event);
            }
        });
        this.sourceTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                SlushBucketPropertyEditor.this.handleSourceTableFocusGainedEvent();
            }
        });
        this.sourceTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == ' ') {
                    SlushBucketPropertyEditor.this.handleSourceTableEnterKeyPressEvent();
                }
            }
        });
        this.valuesProviderListener = new PossibleValuesProviderListener(){

            public void handlePossibleValuesChangedEvent(PossibleValuesChangedEvent event) {
                SlushBucketPropertyEditor.this.sourceTableViewer.refresh();
                SlushBucketPropertyEditor.this.addAction.notifyChangeListeners();
            }
        };
        this.valuesProvider.addListener(this.valuesProviderListener);
        this.sourceTableViewer.setInput(new Object());
        return composite;
    }

    public Action createAddAction() {
        this.addAction = new AddAction();
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<String> input = new ArrayList<String>();
                Iterator itr = ((IStructuredSelection)event.getSelection()).iterator();
                while (itr.hasNext()) {
                    input.add((String)itr.next());
                }
                SlushBucketPropertyEditor.this.addAction.setInput(input);
            }
        };
        this.sourceTableViewer.addSelectionChangedListener(listener);
        return this.addAction;
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.sourceTableViewer.refresh();
        this.addAction.notifyChangeListeners();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.sourceTableViewer.refresh();
        this.addAction.notifyChangeListeners();
    }

    protected void handleTableFocusGainedEvent() {
        super.handleTableFocusGainedEvent();
        this.sourceTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void handleDisposeEvent() {
        super.handleDisposeEvent();
        if (this.valuesProviderListener != null) {
            this.valuesProvider.removeListener(this.valuesProviderListener);
        }
    }

    private void handleSourceTableDoubleClickEvent(MouseEvent event) {
        String doubleClickedItem = null;
        TableItem[] tableItemArray = this.sourceTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getBounds().contains(event.x, event.y)) {
                doubleClickedItem = (String)item.getData();
                break;
            }
            ++n2;
        }
        if (doubleClickedItem != null) {
            this.addAction.setInput(Collections.singleton(doubleClickedItem));
            this.addAction.execute(this.getUiContext().getShell());
        }
    }

    private void handleSourceTableFocusGainedEvent() {
        this.setSelection(Collections.<IModelElement>emptyList());
        if (this.sourceTableViewer.getSelection().isEmpty() && this.sourceTable.getItemCount() > 0) {
            String firstItem = (String)this.sourceTable.getItem(0).getData();
            this.sourceTableViewer.setSelection((ISelection)new StructuredSelection((Object)firstItem));
        }
    }

    private void handleSourceTableEnterKeyPressEvent() {
        if (!this.sourceTableViewer.getSelection().isEmpty()) {
            this.addAction.execute(this.getUiContext().getShell());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddAction
    extends Action {
        private Collection<String> input = Collections.emptyList();

        private AddAction() {
        }

        public void setInput(Collection<String> input) {
            this.input = input;
            this.notifyChangeListeners();
        }

        @Override
        public boolean isEnabled() {
            ModelElementList<IModelElement> list = SlushBucketPropertyEditor.this.getList();
            if (list != null) {
                return !this.input.isEmpty();
            }
            return false;
        }

        @Override
        protected Object run(Shell shell) {
            ModelElementList<IModelElement> list = SlushBucketPropertyEditor.this.getList();
            if (list != null) {
                ArrayList<IModelElement> items = new ArrayList<IModelElement>();
                for (String str : this.input) {
                    IModelElement item = list.addNewElement();
                    SlushBucketPropertyEditor.this.memberProperty.invokeSetterMethod((Object)item, (Object)str);
                    items.add(item);
                }
                SlushBucketPropertyEditor.this.setSelection(items);
                SlushBucketPropertyEditor.this.setFocusOnTable();
            }
            return null;
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty memberProperty;
            ModelElementType memberType;
            List properties;
            ListProperty listProperty;
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ListProperty && property.hasAnnotation(NoDuplicates.class) && (listProperty = (ListProperty)property).getAllPossibleTypes().size() == 1 && (properties = (memberType = listProperty.getType()).getProperties()).size() == 1 && (memberProperty = (ModelProperty)properties.get(0)) instanceof ValueProperty && ((ValueProperty)memberProperty).hasPossibleValuesProvider();
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new SlushBucketPropertyEditor(context, part);
        }
    }
}

