/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public final class ResetActionsAssistContributor
extends PropertyEditorAssistContributor {
    public ResetActionsAssistContributor() {
        this.setId("System.ResetActionsContributor");
        this.setPriority(310);
    }

    public void contribute(PropertyEditorAssistContext context) {
        ModelElementList list;
        final IModelElement element = context.getModelElement();
        final ModelProperty prop = context.getProperty();
        if (prop.isReadOnly()) {
            return;
        }
        if (prop instanceof ValueProperty) {
            Value val = (Value)((ValueProperty)prop).invokeGetterMethod((Object)element);
            if (val.getText(false) != null) {
                boolean hasDefaultValue = element.service().getDefaultValue((ValueProperty)prop) != null;
                boolean isBooleanType = prop.getTypeClass().equals(Boolean.class);
                String actionText = hasDefaultValue || isBooleanType ? Resources.restoreDefaultValue : Resources.clearValue;
                PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
                contribution.setText("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(actionText) + "</a></p>");
                contribution.setHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        ((ValueProperty)prop).invokeSetterMethod((Object)element, null);
                    }
                });
                PropertyEditorAssistSection section = context.getSection("actions");
                section.addContribution(contribution);
            }
        } else if (prop instanceof ListProperty && !(list = (ModelElementList)prop.invokeGetterMethod((Object)element)).isEmpty()) {
            PropertyEditorAssistContribution contribution = new PropertyEditorAssistContribution();
            contribution.setText("<p><a href=\"action\" nowrap=\"true\">" + ResetActionsAssistContributor.escapeForXml(Resources.clearList) + "</a></p>");
            contribution.setHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    list.clear();
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution);
        }
    }

    private static final class Resources
    extends NLS {
        public static String restoreDefaultValue;
        public static String clearValue;
        public static String clearList;

        static {
            Resources.initializeMessages((String)ResetActionsAssistContributor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

