/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist.internal;

import java.net.URL;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.JumpHandler;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class UrlValueJumpHandler
extends JumpHandler {
    public boolean isApplicable(ValueProperty property) {
        return property.isOfType(URL.class);
    }

    public boolean canLocateJumpTarget(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        Value value = (Value)property.invokeGetterMethod((Object)modelElement);
        return value.validate().getSeverity() != 4;
    }

    public void jump(SapphirePart part, SapphireRenderingContext context, IModelElement modelElement, ValueProperty property) {
        URL url = (URL)((Value)property.invokeGetterMethod((Object)modelElement)).getContent();
        if (url != null) {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(url);
            }
            catch (PartInitException e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }
}

