/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import org.eclipse.sapphire.modeling.BundleResourceModelStore;
import org.eclipse.sapphire.modeling.ByteArrayModelStore;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelStore;
import org.eclipse.sapphire.modeling.SharedModelsCache;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;
import org.eclipse.sapphire.ui.def.internal.SapphireUiDef;

public final class SapphireUiDefFactory {
    public static ISapphireUiDef load(String bundleId, String path) {
        return SapphireUiDefFactory.load(new ModelStoreForXml((ByteArrayModelStore)new BundleResourceModelStore(bundleId, path)), false);
    }

    public static ISapphireUiDef load(ModelStoreForXml modelStore, boolean writable) {
        ISapphireUiDef model;
        if (writable) {
            model = new SapphireUiDef(modelStore);
        } else {
            model = (ISapphireUiDef)SharedModelsCache.retrieve((ModelStore)modelStore, (ModelElementType)ISapphireUiDef.TYPE);
            if (model == null) {
                model = new SapphireUiDef(modelStore);
                SharedModelsCache.store((IModel)model);
            }
        }
        return model;
    }

    public static ISapphireUiDef create() {
        ModelStoreForXml modelStore = new ModelStoreForXml(new ByteArrayModelStore());
        return new SapphireUiDef(modelStore);
    }

    public static ISapphireCompositeDef getCompositeDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getCompositeDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireCompositeDef getCompositeDef(String bundleId, String defFilePath, String compositeId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return def.getCompositeDef(compositeId, true);
    }

    public static ISapphireDialogDef getDialogDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getDialogDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireDialogDef getDialogDef(String bundleId, String defFilePath, String wizardId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return def.getDialogDef(wizardId, true);
    }

    public static ISapphireWizardDef getWizardDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getWizardDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireWizardDef getWizardDef(String bundleId, String defFilePath, String wizardId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return def.getWizardDef(wizardId, true);
    }

    private static String[] parseDefPath(String path) {
        int firstSeparator = path.indexOf(47);
        int secondSeparator = path.lastIndexOf(33);
        int lastIndex = path.length() - 1;
        if (firstSeparator <= 0 || firstSeparator >= lastIndex || secondSeparator <= 0 || secondSeparator >= lastIndex || firstSeparator > secondSeparator) {
            throw new IllegalArgumentException();
        }
        String bundleId = path.substring(0, firstSeparator);
        String defFilePath = path.substring(firstSeparator + 1, secondSeparator);
        String compositeId = path.substring(secondSeparator + 1);
        return new String[]{bundleId, defFilePath, compositeId};
    }
}

