/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.ui.def.IActionDef;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionDef
extends ModelElementForXml
implements IActionDef {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_ID = new XmlPath("id", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_IMPL_CLASS = new XmlPath("class", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_LABEL = new XmlPath("label", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private Value<String> id = null;
    private ReferenceValue<Class<?>> implClass = null;
    private Value<String> label = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ID, PATH_ID);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_IMPL_CLASS, PATH_IMPL_CLASS);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_LABEL, PATH_LABEL);
    }

    public ActionDef(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getId() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.id == null) {
                this.refresh((ModelProperty)PROP_ID, true);
            }
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ID.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ID, true);
            if (!ActionDef.equal((String)this.id.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_ID, value, true);
                this.refresh((ModelProperty)PROP_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<Class<?>> getImplClass() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.implClass == null) {
                this.refresh((ModelProperty)PROP_IMPL_CLASS, true);
            }
            return this.implClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImplClass(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_IMPL_CLASS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_IMPL_CLASS, true);
            if (!ActionDef.equal((String)this.implClass.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_IMPL_CLASS, value, true);
                this.refresh((ModelProperty)PROP_IMPL_CLASS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getLabel() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.label == null) {
                this.refresh((ModelProperty)PROP_LABEL, true);
            }
            return this.label;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLabel(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_LABEL.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_LABEL, true);
            if (!ActionDef.equal((String)this.label.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_LABEL, value, true);
                this.refresh((ModelProperty)PROP_LABEL, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ID) {
                if (this.id != null || force) {
                    Value<String> oldValue = this.id;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_ID, false);
                    this.id = new Value((IModelElement)this, PROP_ID, PROP_ID.encodeKeywords(val));
                    this.id.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ID);
                    if (oldValue != null) {
                        if (this.id.equals(oldValue)) {
                            this.id = oldValue;
                        }
                        if (this.id != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_ID);
                        }
                    }
                }
            } else if (property == PROP_IMPL_CLASS) {
                if (this.implClass != null || force) {
                    ReferenceValue<Class<?>> oldValue = this.implClass;
                    XmlElement element = this.getXmlElement(false);
                    String val = element == null ? null : element.getChildNodeText(PATH_IMPL_CLASS, false);
                    this.implClass = new ReferenceValue((IModelElement)this, PROP_IMPL_CLASS, PROP_IMPL_CLASS.encodeKeywords(val));
                    this.implClass.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_IMPL_CLASS);
                    if (oldValue != null) {
                        if (this.implClass.equals(oldValue)) {
                            this.implClass = oldValue;
                        }
                        if (this.implClass != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_IMPL_CLASS);
                        }
                    }
                }
            } else if (property == PROP_LABEL && (this.label != null || force)) {
                Value<String> oldValue = this.label;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_LABEL, false);
                this.label = new Value((IModelElement)this, PROP_LABEL, PROP_LABEL.encodeKeywords(val));
                this.label.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_LABEL);
                if (oldValue != null) {
                    if (this.label.equals(oldValue)) {
                        this.label = oldValue;
                    }
                    if (this.label != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_LABEL);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

