/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModel;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.xml.ModelElementForXml;
import org.eclipse.sapphire.modeling.xml.ModelStoreForXml;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.ui.def.IActionDef;
import org.eclipse.sapphire.ui.def.IActionOverride;
import org.eclipse.sapphire.ui.def.internal.ActionDef;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionOverride
extends ModelElementForXml
implements IActionOverride {
    private static final Map<ModelProperty, XmlPath> MAP_PROP_TO_XML_PATH = new HashMap<ModelProperty, XmlPath>();
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(TYPE);
    private static final XmlPath PATH_ACTION = new XmlPath("action", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private static final XmlPath PATH_ID = new XmlPath("id", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    private IActionDef action = null;
    private boolean actionCached = false;
    private XmlElement actionElement = null;
    private Value<String> id = null;

    static {
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ACTION, PATH_ACTION);
        MAP_PROP_TO_XML_PATH.put((ModelProperty)PROP_ID, PATH_ID);
    }

    public ActionOverride(IModelParticle parent, ModelProperty parentProperty, XmlElement element) {
        super(TYPE, parent, parentProperty, element);
        ((ModelStoreForXml)this.getModel().getModelStore()).registerModelElement((Node)element.getDomNode(), (IModelElement)this);
    }

    @Override
    public IActionDef getAction() {
        return this.getAction(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IActionDef getAction(boolean createIfNecessary) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (!this.actionCached) {
                this.refresh((ModelProperty)PROP_ACTION, true);
            }
            if (this.action == null && createIfNecessary) {
                this.validateEdit();
                this.getXmlElement(true).getChildNode(PATH_ACTION, true);
                this.refresh((ModelProperty)PROP_ACTION, true);
            }
            return this.action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getId() {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (this.id == null) {
                this.refresh((ModelProperty)PROP_ID, true);
            }
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String value) {
        IModel iModel = this.model;
        synchronized (iModel) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_ID.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_ID, true);
            if (!ActionOverride.equal((String)this.id.getText(false), (String)value)) {
                this.validateEdit();
                this.getXmlElement(true).setChildNodeText(PATH_ID, value, true);
                this.refresh((ModelProperty)PROP_ID, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModel iModel = this.model;
        synchronized (iModel) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ACTION) {
                if (this.actionCached || force) {
                    XmlNode child;
                    this.actionCached = true;
                    IActionDef element = null;
                    XmlElement el = this.getXmlElement(false);
                    XmlNode xmlNode = child = el == null ? null : el.getChildNode(PATH_ACTION, false);
                    if (child == null) {
                        this.actionElement = null;
                    } else if (!child.equals((Object)this.actionElement)) {
                        this.actionElement = (XmlElement)child;
                        element = new ActionDef((IModelParticle)this, (ModelProperty)PROP_ACTION, this.actionElement);
                    } else {
                        element = this.action;
                    }
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ACTION);
                    if (this.action != element) {
                        if (this.action != null) {
                            this.action.dispose();
                        }
                        this.action = element;
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ACTION);
                    } else if (propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ACTION);
                    }
                }
            } else if (property == PROP_ID && (this.id != null || force)) {
                Value<String> oldValue = this.id;
                XmlElement element = this.getXmlElement(false);
                String val = element == null ? null : element.getChildNodeText(PATH_ID, false);
                this.id = new Value((IModelElement)this, PROP_ID, PROP_ID.encodeKeywords(val));
                this.id.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_ID);
                if (oldValue != null) {
                    if (this.id.equals(oldValue)) {
                        this.id = oldValue;
                    }
                    if (this.id != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_ID);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlElement element = this.getXmlElement(false);
            if (element != null) {
                this.validateEdit();
                element.remove();
            }
        }
        IModelParticle parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ModelElementList) {
                ((ModelElementList)parent).handleElementRemovedEvent();
            } else {
                ((IModelElement)parent).refresh(this.getParentProperty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlNode getXmlNode(ModelProperty property) {
        IModel iModel = this.model;
        synchronized (iModel) {
            XmlPath path;
            property = property.refine((IModelElement)this);
            XmlElement el = this.getXmlElement(false);
            if (el != null && (path = MAP_PROP_TO_XML_PATH.get(property)) != null) {
                return el.getChildNode(path, false);
            }
            return null;
        }
    }
}

