/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.def.IEditorPageDef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeDef;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentTree {
    private static final String PREFS_EXPANDED = "Expanded";
    private static final String PREFS_SELECTED = "Selected";
    private final MasterDetailsPage page;
    private final IEditorPageDef pageDef;
    private final IModelElement rootModelElement;
    private MasterDetailsContentNode root;
    private List<MasterDetailsContentNode> selection;
    private final Set<Listener> listeners;
    private String filterText;

    public MasterDetailsContentTree(MasterDetailsPage page, IEditorPageDef pageDef, IModelElement rootModelElement) {
        this.page = page;
        this.pageDef = pageDef;
        this.rootModelElement = rootModelElement;
        this.selection = Collections.emptyList();
        this.listeners = new CopyOnWriteArraySet<Listener>();
        this.filterText = "";
    }

    public MasterDetailsContentNode getRoot() {
        if (this.root == null) {
            IMasterDetailsTreeNodeDef rootNodeDef = this.pageDef.getRootNode();
            this.root = new MasterDetailsContentNode();
            this.root.init(this.page, this.rootModelElement, rootNodeDef, Collections.<String, String>emptyMap());
            this.loadTreeState();
            this.addListener(new Listener(){

                @Override
                public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
                    MasterDetailsContentTree.this.saveTreeState();
                }

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> newSelection) {
                    MasterDetailsContentTree.this.saveTreeState();
                }

                @Override
                public void handleNodeStructureChange(MasterDetailsContentNode node) {
                    MasterDetailsContentTree.this.handleNodeStructureChange();
                }
            });
        }
        return this.root;
    }

    public MasterDetailsContentNode getSelectedNode() {
        if (this.selection.isEmpty()) {
            return null;
        }
        return this.selection.get(0);
    }

    public List<MasterDetailsContentNode> getSelectedNodes() {
        return this.selection;
    }

    public void setSelectedNode(MasterDetailsContentNode selection) {
        if (selection == null) {
            this.setSelectedNodes(Collections.<MasterDetailsContentNode>emptyList());
        } else {
            this.setSelectedNodes(Collections.singletonList(selection));
        }
    }

    public void setSelectedNodes(List<MasterDetailsContentNode> selection) {
        if (!this.selection.equals(selection)) {
            for (MasterDetailsContentNode node : selection) {
                MasterDetailsContentNode parent = node.getParentNode();
                if (parent == null) continue;
                parent.setExpanded(true);
            }
            this.selection = selection.isEmpty() ? Collections.emptyList() : new ArrayList<MasterDetailsContentNode>(selection);
            this.notifyOfSelectionChange(this.selection);
        }
    }

    public void setSelection(String path) {
        MasterDetailsContentNode node = this.root;
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            boolean segmentMatched = false;
            for (MasterDetailsContentNode n3 : node.getChildNodes()) {
                if (!n3.getLabel().equals(segment)) continue;
                node = n3;
                segmentMatched = true;
                break;
            }
            if (!segmentMatched) break;
            ++n2;
        }
        if (node != this.root) {
            this.setSelectedNode(node);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        for (MasterDetailsContentNode node : this.root.getChildNodes()) {
            node.getExpandedNodes(result);
        }
        return result;
    }

    public void setExpandedNodes(Set<MasterDetailsContentNode> expandedNodes) {
        for (MasterDetailsContentNode node : this.root.getChildNodes()) {
            MasterDetailsContentTree.setExpandedNodes(node, expandedNodes);
        }
    }

    private static void setExpandedNodes(MasterDetailsContentNode node, Set<MasterDetailsContentNode> expandedNodes) {
        for (MasterDetailsContentNode child : node.getChildNodes()) {
            MasterDetailsContentTree.setExpandedNodes(child, expandedNodes);
        }
        boolean shouldBeExpanded = expandedNodes.contains(node);
        if (node.isExpanded() != shouldBeExpanded) {
            node.setExpanded(shouldBeExpanded);
        }
    }

    public String getFilterText() {
        return this.filterText;
    }

    public void setFilterText(String filterText) {
        if (!this.filterText.equals(filterText)) {
            this.filterText = filterText;
            this.notifyOfFilterChange(filterText);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void notifyOfNodeUpdate(MasterDetailsContentNode node) {
        for (Listener listener : this.listeners) {
            listener.handleNodeUpdate(node);
        }
        MasterDetailsContentNode parent = node.getParentNode();
        if (parent != null) {
            this.notifyOfNodeUpdate(parent);
        }
    }

    public void notifyOfNodeStructureChange(MasterDetailsContentNode node) {
        for (Listener listener : this.listeners) {
            listener.handleNodeStructureChange(node);
        }
    }

    public void notifyOfNodeExpandedStateChange(MasterDetailsContentNode node) {
        for (Listener listener : this.listeners) {
            listener.handleNodeExpandedStateChange(node);
        }
    }

    public void notifyOfSelectionChange(List<MasterDetailsContentNode> newSelection) {
        for (Listener listener : this.listeners) {
            listener.handleSelectionChange(newSelection);
        }
    }

    private void notifyOfFilterChange(String newFilterText) {
        for (Listener listener : this.listeners) {
            listener.handleFilterChange(newFilterText);
        }
    }

    public void refresh() {
        this.notifyOfNodeStructureChange(null);
    }

    public void dispose() {
        if (this.root != null) {
            this.root.dispose();
        }
    }

    private void handleNodeStructureChange() {
        ArrayList<MasterDetailsContentNode> newSelection = new ArrayList<MasterDetailsContentNode>();
        for (MasterDetailsContentNode node : this.selection) {
            LinkedList<MasterDetailsContentNode> path = new LinkedList<MasterDetailsContentNode>();
            while (node != this.root) {
                path.addFirst(node);
                node = node.getParentNode();
            }
            node = this.root;
            for (MasterDetailsContentNode n : path) {
                if (!node.getChildNodes().contains(n)) break;
                node = n;
            }
            if (node == this.root) {
                List<MasterDetailsContentNode> topLevelNodes = this.root.getChildNodes();
                node = topLevelNodes.size() > 0 ? topLevelNodes.get(0) : null;
            }
            if (newSelection.contains(node)) continue;
            newSelection.add(node);
        }
        this.setSelectedNodes(newSelection);
    }

    private void loadTreeState() {
        try {
            ArrayList<MasterDetailsContentNode> selection = new ArrayList<MasterDetailsContentNode>();
            Preferences prefs = this.page.getInstancePreferences(false);
            if (prefs != null && prefs.nodeExists("ContentTreeState")) {
                prefs = prefs.node("ContentTreeState");
                for (MasterDetailsContentNode node : this.root.getChildNodes()) {
                    this.loadTreeState(prefs, node, selection);
                }
            }
            if (!selection.isEmpty()) {
                this.setSelectedNodes(selection);
            } else {
                MasterDetailsContentNode node;
                node = this.root;
                String defaultInitialNodePath = this.pageDef.getInitialSelectionPath().getText();
                if (defaultInitialNodePath != null) {
                    String[] stringArray = defaultInitialNodePath.split("/");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        if ((node = node.getChildNodeByLabel(segment)) == null) break;
                        node.setExpanded(true);
                        ++n2;
                    }
                }
                if (node != null) {
                    this.setSelectedNode(node);
                }
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    private void loadTreeState(Preferences parentPrefs, MasterDetailsContentNode node, List<MasterDetailsContentNode> selection) throws BackingStoreException {
        String nodeLabel = node.getLabel();
        if (parentPrefs.nodeExists(nodeLabel)) {
            Preferences prefs = parentPrefs.node(nodeLabel);
            if (prefs.getBoolean(PREFS_EXPANDED, false)) {
                node.setExpanded(true);
            }
            if (prefs.getBoolean(PREFS_SELECTED, false)) {
                selection.add(node);
            }
            for (MasterDetailsContentNode child : node.getChildNodes()) {
                this.loadTreeState(prefs, child, selection);
            }
        }
    }

    private void saveTreeState() {
        try {
            Preferences prefs = this.page.getInstancePreferences(true).node("ContentTreeState");
            String[] stringArray = prefs.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeLabel = stringArray[n2];
                prefs.node(nodeLabel).removeNode();
                ++n2;
            }
            List<MasterDetailsContentNode> selection = this.getSelectedNodes();
            for (MasterDetailsContentNode node : this.root.getChildNodes()) {
                this.saveTreeState(prefs, node, selection);
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    private void saveTreeState(Preferences parentPrefs, MasterDetailsContentNode node, List<MasterDetailsContentNode> selection) throws BackingStoreException {
        boolean isExpanded = node.isExpanded();
        boolean isSelected = selection.contains(node);
        if (isExpanded || isSelected) {
            Preferences prefs = parentPrefs.node(node.getLabel());
            if (isExpanded) {
                prefs.putBoolean(PREFS_EXPANDED, true);
            }
            if (isSelected) {
                prefs.putBoolean(PREFS_SELECTED, true);
            }
            for (MasterDetailsContentNode child : node.getChildNodes()) {
                this.saveTreeState(prefs, child, selection);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Listener {
        public void handleNodeUpdate(MasterDetailsContentNode node) {
        }

        public void handleNodeStructureChange(MasterDetailsContentNode node) {
        }

        public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
        }

        public void handleSelectionChange(List<MasterDetailsContentNode> newSelection) {
        }

        public void handleFilterChange(String newFilterText) {
        }
    }
}

